function rochevis,model,lamda,u,v,fluxes,init=init
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Prepare a call to rochevis, which computes visibilities for a Roche sphere.
; Lambda[m], u, and v should be vectors.
;
common LimbBase,limb_data
common LocalRocheVis,LDinit
common AuxData,parallaxes,k1,k2,vsini
;
if n_elements(limb_data) eq 0 then $
restore,!atmospheres_dir+'vanhamme/limbdata.xdr'
;
rocheparms=setrocheparms(model,lamda,u,v)
;
lam=float(lamda)
nl=n_elements(lam)
vr=fltarr(nl)
vi=vr
fluxes=fltarr(nl)
um=float(u)*lam		; convert u,v coordinates in meters
vm=float(v)*lam
vsi=0.0
;
lam=lam*1e9		; convert to nm
;
; Prepare LD data
if n_elements(LDinit) eq 0 then LDinit=1
if LDinit ne 0 then begin
	case model.model of
		'Log' :LDinit=2l
		'Sqrt':LDinit=3l
	 	else  :LDinit=1L
	endcase
endif
if n_elements(init) ne 0 then LDinit=long(init)
if LDinit gt 0 then begin
	afTeff=float(unique(limb_data.t))
	iTeffMax=n_elements(afTeff)
	afLogG=reverse(float(unique(limb_data.g)))
	iLogGMax=n_elements(afLogG)
	afWaves=float(unique(limb_data.w))
	iWavesMax=n_elements(afWaves)
	afLD=fltarr(3,iTeffMax,iLogGMax,iWavesMax)
	for i=0,n_elements(limb_data.m)-1 do begin
		index=where(limb_data.n eq limb_data.m[i])
		iT=where(afTeff eq limb_data.t[i]) & iT=iT[0]
		iG=where(afLogG eq limb_data.g[i]) & iG=iG[0]
		case LDinit of
		1: afLD[0,iT,iG,*]=limb_data.u[index]
		2: begin
		   afLD[0,iT,iG,*]=limb_data.x[index]
		   afLD[1,iT,iG,*]=limb_data.y[index]
		   end
		3: begin
		   afLD[0,iT,iG,*]=limb_data.a[index]
		   afLD[1,iT,iG,*]=limb_data.b[index]
		   end
		endcase
		afLD[2,iT,iG,*]=(limb_data.f[index]/1e0) $
			       /blackbody(afTeff[iT],afWaves/1e9)
	endfor
	aiLogG=lonarr(iTeffMax)
	for i=0,iTeffMax-1 do $
		aiLogG[i]=n_elements(where(limb_data.t eq afTeff[i]))
endif else begin
	afTeff=0.
	iTeffMax=0l
	afLogG=0.
	iLogGMax=0l
	afWaves=0.
	iWavesMax=0l
	afLD=0.
	aiLogG=0l
endelse
;
status=linknload(!external_lib,'peterson',rocheparms,nl,lam,vr,vi,fluxes, $
		um,vm, $
		LDinit,iWavesMax,iTeffMax,iLogGMax,aiLogG, $
		afLD,afLogG,afWaves,afTeff,vsi)
LDinit=0l
;
if n_elements(vsini) ne 0 then vsini.valuem=vsi
;
return,complex(vr,vi)
;
end
