pro roseset,uptime
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; In contrast to procedure riseset, this one gets the actual times from
; a the currently loaded data set.
;
common StarBase,StarTable,Notes
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
num_stars=n_elements(StarTable)
if num_stars eq 0 then begin
        print,'***Error(ROSESET): no stars defined!'
        return
endif
;
if n_elements(scans) eq 0 then begin
	print,'***Error(ROSESET): no ScanData!'
	return
endif
;
uptime=fltarr(2,num_stars)
for i=0,num_stars-1 do begin
        index=where(scans.starid eq StarTable[i].starid,count)
        if count gt 0 then begin
        	times=scans[index].time
        	index=where(times gt 0,count)
        	if count eq 0 then begin
                	uptime[*,i]=0
        	endif else begin
                	uptime[0,i]=min(times[index])
                	uptime[1,i]=max(times[index])
        	endelse
        endif else uptime[*,i]=0
endfor
;
end
