function rotateframe,c,l,d,a
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; l = wavelength [m]
; d = delay tracking offset [m]
; a = airpath [m]
;
; Rotate a frame by d and a. The airpath is translated into delay using
; the refractive index of air for wavelengths l.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
r=size(c)
numbin=r[1]
;
if n_elements(d) eq 1 then g=[d] else g=reform(d)
if n_elements(a) ne 0 then begin
	n=edlen(l*1e6)
	g=reform((l*0+1)#g+(n-1)#a,n_elements(l),n_elements(a))
endif
r=size(g)
if r[0] eq 1 then s=nint((numbin/l)#g) $
	     else begin
		  s=fix(g)
		  for j=0,n_elements(l)-1 do s[j,*]=nint(numbin/l[j]*g[j,*])
	          endelse
;
c_r=c
;
for i=0L,n_elements(d)-1 do begin
for j=0L,n_elements(l)-1 do begin
	c_r[*,j,i]=shift(c[*,j,i],s[j,i])
endfor
endfor
;
return,c_r
;
end
