pro save_flagtable,table,folder=folder
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Save the specified flag table to a file, making sure that the other
; tables in this file are preserved.
;
common Hds,path,hds_file_stub
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
if n_elements(folder) eq 0 then folder=''
;
filename=folder+'/'+hds_file_stub+'.flg'
result=file_search(filename,count=fcount)
if fcount ne 0 then restore,filename
;
if n_elements(point_table) eq 0 then point_table=0
if n_elements(inch_table) eq 0 then inch_table=0
if n_elements(bg_table) eq 0 then bg_table=0
if n_elements(scan_table) eq 0 then scan_table=0
;
case table of
	'point':point_table=pointflagtable
	'inch':	inch_table=inchflagtable
	'bg':	bg_table=bgflagtable
	'scan':	scan_table=scanflagtable
endcase
;
if !idl then save,filename=filename,point_table,inch_table,bg_table,scan_table $
        else cmsave,filename=filename,point_table,inch_table,bg_table,scan_table
;
end
