pro saverestore,file,action
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Saves/restores OYSTER session to/from file. Single night data only!
;
; Common blocks included here will be saved/restored from file
common StarBase,startable,notes
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common InchData,Sol0,SolN,Jscan,MetroTime,PivotMotion, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common AuxData,parallaxes,k1,k2,vsini
;
if n_elements(file) eq 0 then begin
	print,'***Error(SAVERESTORE): file undefined!'
	return
endif
if file eq '' then begin
	print,'***Error(SAVERESTORE): file unspecified!'
	return
endif
if n_elements(action) eq 0 then begin
	print,'***Error(SAVERESTORE): action undefined!'
	return
endif
if action eq '' then begin
	print,'***Error(SAVERESTORE): action unspecified!'
	return
endif
;
case action of
	'save'   :begin
	  	  save,filename=file,/variables
	  	  print,'Common block data saved to: ',file
	  	  end
	'restore':begin
		  result=file_search(file,count=fcount)
		  if fcount ne 0 then begin
			restore,filename=file
			print,'Common block data restored.'
	  	  endif else begin
			print,'***Error(SAVERESTORE): file not found: ',file,'!'
			return
		  endelse
		  end
	     else:begin
		  print,'***Error(SAVERESTORE): unknown action: ',action,'!'
		  return
		  end
endcase
;
end
