function scan
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
NIB=GenConfig.NumSid
NOB=GenConfig.NumOutBeam
NTR=GenConfig.NumTriple
;
; We need to allocate space for at least one triple
if NTR eq 0 then NTR=1
;
; Find out about the maximum number of baselines/outputbeam: MB
MB=max(GenConfig.NumBaseline)
MB=n_elements(GenConfig.BaselineId[*,0])	; equalize dimensions
;
; Find out about the maximum number of spectral channels/outputbeam: MC
MC=max([GenConfig.NumSpecChan,GenConfig.TripleNumChan])
MC=n_elements(GenConfig.Wavelength[*,0])	; equalize dimensions
;
if NIB*NOB*NTR*MC*MB eq 0 then return,-1
return,allocscan(NIB,NOB,NTR,MC,MB)
end
