function scanconfig,cf,coherent=coherent,starlist=starlist,maxconfig=maxconfig
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; The scan configuration specifies which of the configured stations (the ones
; given in the general configuration) were actually used on a scan by scan basis
; This information is only important for system calibrations such as bias
; and response, the results of which are stored in GenConfig.
;
; Multi-purpose function for scan configuration inquiries.
; Examples: 	cf=<undefined>:	return existing scan configurations
;		cf='111010':	return scan ids with this configuration (code=7)
;		cf=14:		return configuration for this scan (code=2)
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(coherent) eq 0 then coherent=0 else coherent=coherent gt 0
if n_elements(starlist) eq 0 then starlist=0 else starlist=starlist gt 0
if n_elements(maxconfig) eq 0 then maxconfig=0 else maxconfig=maxconfig gt 0
;
if maxconfig then begin
	if n_elements(scantable) eq 0 then return,300
	return,n_elements(scantable)
endif
if n_elements(scantable) eq 0 then return,-1
if n_elements(genconfig) ne 0 then index=indgen(genconfig.numsid) $
			      else index=where(total(scantable.station,2) gt 0)
stations=scantable.station[index]
stations=strcompress(strjoin(string(stations)),/remove)
starids=' '+scantable.starid
;
r=size(cf) & code=r[n_elements(r)-2]
if code eq 0 then begin
	if coherent then begin
		index=where(scantable.code eq 1,count)
		if count eq 0 then return,''
		stations=stations[index]
		starids=starids[index]
	endif
	if not starlist then starids=''
	return,unique(stations+starids)
endif
;
if code eq 7 then begin
	index=0
	for i=0,n_elements(cf)-1 do begin
		if coherent then index=[index,where(stations eq cf[i] $
						and scantable.code eq 1)+1] $
			    else index=[index,where(stations eq cf[i])+1]
	endfor
	jndex=where(index gt 0,count)
	if count eq 0 then return,0 else return,unique(index[jndex])
endif
;
starid=' '+scantable[cf-1].starid
if not starlist then starid=''
if code eq 2 or code eq 3 then $
return,stations[cf-1]+starid
;
end
