function scanindex,times
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given list of times [s], return indices of matching scans.
; Ignore times outside of any scan boundaries.
;
common Tables,ScanTable,BGTable,StationTable
;
n=n_elements(times)
index=intarr(n)
k=0
for i=0,n-1 do begin
	j=where(scantable.starttime le (times[i]+1) $
	    and scantable.stoptime ge (times[i]-1),count)
	if count eq 1 then begin
		index[k]=j
		k=k+1
	endif
endfor
if k gt 0 then return,index[0:k-1] else return,-1
;
end
