pro scramble
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Create a random vector of station phases and use them to scramble the observed
; phases. For testing purposes.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Determine number of spectral channels
uci=unique(ci)
numchan=n_elements(uci)
;
; Determine number of stations
numsid=max(unique(bi) mod 1000)
;
; Determine number of scans
numscan=n_elements(unique(si))
numscan=max(si)
;
for i=0,numscan-1 do begin
for j=0,numchan-1 do begin
	index=where(ci eq uci[j] and si eq i+1,count)
	if count gt 0 then begin
	dmatrix=fltarr(count,numsid)
	for l=0,count-1 do begin
		dmatrix[l,(bi[index[l]] mod 1000)-1]=+1
		dmatrix[l,(bi[index[l]]  /  1000)-1]=-1
	endfor
	sp=randomu(seed,numsid)*2*!pi
	rp=dmatrix#sp
	cv[index]=cv[index]*conj(complex(cos(rp),sin(rp)))
	endif	; End of: "Are there any data for this channel?"
endfor
endfor
;
y=cphase(cv)-cphase(mv)
jndex=where(y gt !pi,jc)
if jc gt 0 then y[jndex]=y[jndex]-2*!pi
jndex=where(y lt -!pi,jc)
if jc gt 0 then y[jndex]=y[jndex]+2*!pi
phase_rms=stddev(y)*180/!pi
print,'Station phases scrambled, phase RMS [deg] = ',phase_rms
;
end
