pro sedimages,sedfile,split=split
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ChannelImage,channel_images,channel_wavelengths,images_cellsize
;
if n_elements(sedfile) eq 0 then begin
	print,'***Error: please specify filename!'
	return
endif
;
flux=total(total(channel_images,1),1)
l=channel_wavelengths
;
if keyword_set(split) then begin
	r=poly_fit(l*1e6,flux,1,yfit)
	v=medianve(flux-yfit,e)
	index=where(abs(flux-yfit) lt 2*e)
	r=poly_fit(l[index]*1e6,flux[index],2)
	yfit=poly(l*1e6,r)
	plot,l,flux,psym=0
	oplot,l,yfit,psym=0
	f=yfit
	save,l,f,filename=sedfile+'.A.xdr'
	f=abs(flux-yfit)
	save,l,f,filename=sedfile+'.B.xdr'
	return
endif
;
save,l,f,filename=sedfile
;
end
