pro selectup,from_data,mintime=min
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Extract list of stars from startable which are visible in a given night.
; Reduce startable accordingly. Get times from scan data if from_data=1.
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
num_stars=n_elements(startable)
if num_stars eq 0 then begin
	print,'***Error(SELECTUP): no stars defined!'
	return
endif
;
if n_elements(from_data) eq 0 then from_data=0
if not keyword_set(min) then min=3
;
riseset,uptime,nighttime
if n_elements(uptime) eq 0 then return
if from_data then roseset,uptime
;
uptime=uptime/3600 & nighttime=nighttime/3600
index=where(uptime[1,*] lt uptime[0,*],count)
if count gt 0 then uptime[0,index]=uptime[0,index]-24
;
index=where(uptime[0,*] lt nighttime[1]-min or uptime[1,*] gt nighttime[0]+min)
startable=startable[index]
;
end
