pro selfcal,phase_rms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Experimental version for datasets containing sub-arrays, i.e., station
; indices in the full array need to be translated to sub-array IDs.
;
; Perform a phase self-calibration of complex visibilities (c) using model
; visibilities (m). This algorithm uses a weighting "mask" and SVD to remove
; phase wraps first by computing an exact solution, then by considering more
; baselines to improve the solution up to all available data.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Determine number of spectral channels
uci=unique(ci)
numchan=n_elements(uci)
;
; Determine number of stations in data set
maxsid=max([unique(bi) mod 1000,unique(bi)/1000])
;
; Station index (converted to range [1,2,3,...]
sta_index=intarr(maxsid)
;
; Determine number of scans
numscan=n_elements(unique(si))
numscan=max(si)
;
; Illumination factor
weight=100
;
; SVD eigenvalue tolerance
tolerance=1e-5
;
for i=0,numscan-1 do begin
for j=0,numchan-1 do begin
	index=where(ci eq uci[j] and si eq i+1,count)
	if count gt 0 then begin
;	Compute numsid for sub-array (e.g., Beauty Contest 2020)
	sub_index=unique([bi[index]/1000,bi[index] mod 1000])
	numsid=n_elements(sub_index)
;	Prepare station index for sub-array station IDs
	sta_index=intarr(max(sub_index))
	sta_index[sub_index-1]=indgen(numsid)
	dmatrix=fltarr(count,numsid)
	for l=0,count-1 do begin
		dmatrix[l,sta_index[bi[index[l]] mod 1000-1]]=+1
		dmatrix[l,sta_index[bi[index[l]]  /  1000-1]]=-1
	endfor
	dmatriz=dmatrix
	yweight=fltarr(count)+1
	for k=0,numsid-2 do begin
		y=cphase(cv[index])-cphase(mv[index])
		jndex=where(y gt !pi,jc)
		if jc gt 0 then y[jndex]=y[jndex]-2*!pi
		jndex=where(y lt -!pi,jc)
		if jc gt 0 then y[jndex]=y[jndex]+2*!pi
;		Select all baselines involving station k
		index1=bi[index] mod 1000-1
		index2=bi[index]  /  1000-1
		bindex=where(sta_index[index1] eq k $
			  or sta_index[index2] eq k,count)
;		bindex=where(sub_index(bi(index) mod 1000-1) eq k $
;			  or sub_index(bi(index)  /  1000-1) eq k,count)
		if count gt 0 then begin
			dmatriz[bindex,*]=dmatriz[bindex,*]*weight
			dmatriz=(dmatriz<weight)>(-weight)
			yweight[bindex]=yweight[bindex]*weight
			yweight=(yweight<weight)>(-weight)
			y=y*yweight
                        tmatriz=transpose(dmatriz)
                        nmatriz=tmatriz#dmatriz
                        r=tmatriz#y
			svd8,nmatriz,nw,nu,nv
			windex=where(nw/max(nw) lt tolerance,wcount)
			if wcount gt 0 then nw[windex]=0
			svb8,nu,nw,nv,r,s
			p=dmatrix#s
			cv[index]=cv[index]*conj(complex(cos(p),sin(p)))
		endif
	endfor
delta=180/!pi*stddev(cphase(cv[index])-cphase(mv[index]))
; print,i,j,delta,abs(cv(index))
	endif	; End of: "Are there any data for this channel?"
endfor
endfor
;
y=cphase(cv)-cphase(mv)
jndex=where(y gt !pi,jc)
if jc gt 0 then y[jndex]=y[jndex]-2*!pi
jndex=where(y lt -!pi,jc)
if jc gt 0 then y[jndex]=y[jndex]+2*!pi
phase_rms=stddev(y)*180/!pi
print,'Solution computed, phase RMS [deg] = ',phase_rms
;
end
