function set_axitems,item_ids,units,abbrs
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize item_ids for a given plot class (i.e. selection of data for
; a plot widget), and return string arrays containing the item names and units.
; Note: items referred to by sequence number!
; Labels: 1st Standard, 2nd Paper
; Label extensions: [units], {abbreviation for flag info}
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(class) eq 0 then begin
	print,'***Error(SET_AXITEMS): class not defined!'
	return,''
endif
;
if n_elements(ps_options) eq 0 then pflag=0 else pflag=ps_options.p
;
ax_items=[ $
	['Time [h] {TIME}','Time [h]'], $
	['Index {PT}','Index'], $
	['VisSq {VISSQ}','Squared visbility'], $
	['FASN {FASN}','Fringe amplitude SNR'], $
	['VisPhase [deg] {TPHAS}','Visibility phase'], $
	['TripleAmp {TAMP}','Triple amplitude'], $
	['TriplePhase [deg]','Closure phase'], $
	['PhotonRate {RATE}','Photon rate'], $
	['FDLPath [m]{FDLP}','FDL path'], $
	['DelayJitter [mu]{DJITTR}','Delay jitter'], $
	['NATJitter {TJITTR}','NAT jitter'], $
	['NATCounts {TCOUNTS}','NAT counts'], $
	['GrpDelay [mu]{GRPD}','Group delay [mu]'], $
	['DryDelay [mu]{DRYD}','Dry air disp. corr. delay [mu]'], $
	['WetDelay [mu]{WETD}','Wet air disp. corr. delay [mu]'], $
	['VacDelay [mu]{VACD}','Vacuum delay [microns]'], $
	['FDLDelay (res.) [mu]{FDLD}','FDL delay [microns]'], $
	['MetroDelay [mu]','Metrology delay [microns]'], $
	['Time [h]{TIME}','Time [h]'], $
	['ScanNo {SC}','Scan'], $
	['BGRate {RATE}','Back ground rate'], $
	['Time [h]{TIME}','Time [h]'], $
	['ScanNo {SC}','Scan'], $
	['VisSq {VISSQ}','Squared visibility'], $
	['VisSq c {VISSQ}','Squared visibility'], $
;	['Diameter (mas)','Size (mas)'], $
	['VisSq/e {VISSQ}','Squared visibility'], $
	['VisSq c/e {VISSQ}','Squared visibility'], $
	['ClAmp {TAMP}','Triple amplitude'], $
	['ClAmp c {TAMP}','Triple amplitude'], $
	['ClAmp/e {TAMP}','Triple amplitude'], $
	['ClAmp c/e {TAMP}','Triple amplitude'], $
	['ClPhase [deg]{TPHAS}','Closure phase [deg]'], $
	['ClPhase c [deg]{TPHAS}','Closure phase [deg]'], $
	['PhotonRate {RATE}','Photon rate'], $
	['BackgndRate {RATE}','Back ground rate'], $
	['FDLPath [m] {FDLP}','FDL path'], $
	['DelayJitter [mu]{JITTR}','Delay jitter [microns]'], $
	['TrackJitter','Angle tracking jitter'], $
	['FDLDelay [m] {FDLD}','FDL delay [m]'], $
	['GeoDelay [m]','Geometric delay [m]'], $
;	['UV-Radius [cycles/arcsec]','UV-radius [cycles/arcsec]'], $
	['UV-Radius [M'+greek('lambda')+']','Projected baseline length [M'+greek('lambd
	['HourAngle [h]','Hour angle'], $
	['ZenithAngle [deg]','Zenith angle'], $
	['MirrorAngle [deg]','Mirror angle'], $
	['Wavelength [mu]','Wavelength ['+greek('mu')+'m]'], $
	['Channel','Channel'], $
	['BLlength','Baseline length'], $
	['Baseline [m]','Baseline'], $
	['Triple','Triple'], $
	['u [M'+greek('lambda')+']','u [M'+greek('lambda')+']'], $
	['v [M'+greek('lambda')+']','v [M'+greek('lambda')+']'], $
	['w [M'+greek('lambda')+']','w [M'+greek('lambda')+']'], $
	['FDL_O-C [mu]','FDL O-C [microns]'], $
	['Grp_O-C [mu]','grp O-C [microns]'], $
	['Dry_O-C [mu]','Dry O-C [microns]'], $
	['Wet_O-C [mu]','Wet O-C [microns]'], $
	['VisSq m','Model squared visibility'], $
	['TripleAmp m','Model triple amplitude'], $
	['TriplePhase m','Model closure phase'], $
	['Time [h]','Time [h]'], $
	['Par X [mu]','X [microns]'], $
	['Par Y [mu]','Y [microns]'], $
	['Par Z [mu]','Z [microns]'], $
	['MetroPath [mu]','Metrology path [microns]'], $
	['MetroDelay [mu]','Metrology delay [microns]'], $
	['ModelDelay [mu]','Model delay [microns]'], $
	['MetroDelay [mu]','Metrology delay [microns]'], $
	['Hour angle [h]','Hour angle'], $
	['Declination [d]','Declination'], $
	['Azimuth [d]','Azimuth [deg]'], $
	['Elevation [d]','Elevation [deg]'], $
	['Par X C [microns]','X (corr.) [microns]'], $
	['Par Y C [microns]','Y (corr.) [microns]'], $
	['Par Z C [microns]','Z (corr.) [microns]'], $
	['NATCounts','NAT counts'], $
	['BeamCounts','Beam counts'], $
	['SpecCounts','SpecCounts'], $
	['Azimuth [deg]','Azimuth'], $
	['BL PA [deg E of N]','Baseline PA [deg E of N]'], $
	['SI','Scintillation index'], $
	['R0 ["]','R0 ["]'], $
	['T0 [ms]','T0 [ms]'], $
	['PWV','PWV [mm]'], $
	['DelayRMS [mu]','DelayRMS [mu]'], $
	['PhaseRMS [mu]','PhaseRMS [deg]'], $
	['DelayJitter2','DelayJitter2'], $
	['NATXRMS','NATXRMS'], $
	['NATYRMS','NATYRMS'], $
	['NATRMS','NATRMS'], $
	['TrackJitter2','Angle jitter'], $
	['DiffPhase','Differential phase [deg]'], $
	['DiffPhaseC','Differential phase (cal.) [deg]'], $
	['DiffPhaseM','Model Differential phase [deg]'], $
	['Photometry','Flux (uncal.)'], $
	['PhotometryC','Flux (cal.)'], $
	['PhotometryM','Flux (model)'] $
	]
;
if pflag then ax_items=reform(ax_items[1,*]) $
	 else ax_items=reform(ax_items[0,*])
;
; Extract units and abbreviations
units=strarr(n_elements(ax_items))
abbrs=strarr(n_elements(ax_items))
for i=0,n_elements(ax_items)-1 do begin
	pos=strlen(ax_items[i])
	pos1=strpos(ax_items[i],'[')
	pos2=strpos(ax_items[i],']')
	if pos1 ne -1 and pos2 ne -1 then begin
		pos=min([pos,pos1])
		units[i]=strmid(ax_items[i],pos1,pos2-pos1+1)
	endif
	pos3=strpos(ax_items[i],'{')
	pos4=strpos(ax_items[i],'}')
	if pos3 ne -1 and pos4 ne -1 then begin
		pos=min([pos,pos3])
		abbrs[i]=strmid(ax_items[i],pos3+1,pos4-pos3-1)
	endif
	ax_items[i]=strmid(ax_items[i],0,pos)
endfor
;
; Set list of items for each class
case class of
	'point' :item_ids=[1,2,46,3,4,5,6,7,8,18,10,11,12]
	'delay' :item_ids=[1,2,46,9,17,13,14,15,16,5]
	'bg'    :item_ids=[19,20,21,46]
	'scan'  :begin
		 item_ids=[22,23,45,46,42,43,44,78, $
			   24,25,26,27,34,94,35,28,29,30,31, $
			   32,33]
		 if strpos(instrument_id(systemid),'NPOI') ge 0 then $
		 item_ids=[22,23,45,46,42,43,44,78, $
			   24,25,26,27,28,29,30,31, $
			   32,33,34,35,75,76,77]
		 if strpos(instrument_id(systemid),'GRAVITY') ge 0 then $
		 item_ids=[22,23,45,46,42,43,44,78, $
			   24,25,26,27,91,92,93,94,95,35,28,29,30,31, $
			   32,33]
		 if strpos(instrument_id(systemid),'MATISSE') ge 0 then $
		 item_ids=[22,23,45,46,42,43,44,78, $
			   24,25,26,27,91,92,93,94,95,35,28,29,30,31, $
			   32,33]
		 end
	'astrom':item_ids=[22,42,39,40,66,67,53,54,55,56]
	'seeing':item_ids=[22,80,81,82,84,85,86,37,86,87,88,89,38,90,43,26,34,45]
	'phot'	:item_ids=[22,23,43,90,75]
	'uv'    :item_ids=[25,26,41,79,51,50]
	'metro' :item_ids=[60,68,69,70,71,61,62,63,72,73,74,64,65]
	'amoeba':begin
		 item_ids=[22,23,45,46,42,41,25,26,93,29,33,95,96]
		 if strpos(instrument_id(systemid),'NPOI') ge 0 then $
		 item_ids=[22,23,45,46,42,41,25,29,33]
		 end
	'volvox':item_ids=[22,23,53,54,55]
;	ncal produces plots with these pre-selected (x,y,z)-axes
	'ncal'  :begin
		 if strpos(type,'Response') ge 0 then begin
		 ax_items=[ $
		  '(B-V)', $
		  'Mag/count (1 bl.)', $
		  'Channel']
		 item_ids=[1,2,3]
		 endif else if strpos(type,'V2Bias') ge 0 then begin
		 ax_items=[ $
		  'Photonrate', $
		  'Squared visibility', $
		  'Channel']
		 item_ids=[1,2,3]
		 endif else if strpos(type,'TABias') ge 0 then begin
		 ax_items=[ $
		  'Photonrate', $
		  'TripleAmp', $
		  'Channel']
		 item_ids=[1,2,3]
		 endif else if strpos(type,'APDFlux') ge 0 then begin
		 ax_items=[ $
		  'Scan', $
		  'Rel. rate (O/C)', $
		  'Channel']
		 item_ids=[1,2,3]
		 endif else if strpos(type,'TrackJitter') ge 0 then begin
		 ax_items=[ $
		  'Photonrate', $
		  'TrackJitter', $
		  'Channel']
		 item_ids=[1,2,3]
		 endif else if strpos(type,'TrackOffset') ge 0 then begin
		 ax_items=[ $
		  'Offset', $
		  'Squared visibility', $
		  'Channel']
		 item_ids=[1,2,3]
		 endif
		 end
	    else:begin
		 print,'***Error(SET_AXITEMS): invalid class ',class,'!'
		 return,''
		 end
endcase
units=units[item_ids-1]
return,ax_items[item_ids-1]
;
end
