function set_boxes,box_x,box_y,nbox,clear=clear
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Lets user place boxes in a plot for various purposes.
; Returns button status to identify user command, as well as
; the coordinates, box_x and box_y, and the number, nbox, of the boxes.
;
; if n_elements(clear) eq 0 then clear=0 else clear=clear gt 0
if keyword_set(clear) then begin
; if clear then begin
	if n_elements(nbox) eq 0 then nbox=1
	device,set_graphics_function=6
	for i=0,nbox-1 do plots,box_x[*,i],box_y[*,i],psym=0
	device,set_graphics_function=3
	return,0
endif
;
if n_params() eq 2 then begin
	boxmode=1
	numbox=1
	print,'______________________________________________________'
	print,'Place one box by clicking left mouse button to anchor '
	print,'a corner of the box. Click middle to fix size and to  '
	print,'move box around. Click left button to set the box.'
	print,'Click right button to cancel/reset and return!'
	print,'________________________***___________________________'
endif else begin
	boxmode=0
	numbox=20
	print,'_________________________________________________________'
	print,'You have a maximum of',numbox,' boxes to place! To begin:'
	print,'click left button to anchor a corner of the box. Click   '
	print,'middle button to fix size and to move box around. Click  '
	print,'left button to fix the box.'
	print,'Click right mouse button to exit to edit menu.'
	print,'_________________________***______________________________'
endelse
;
; Box corners start at top left corner and continue clockwise
box_x=fltarr(5,numbox)
box_y=fltarr(5,numbox)
nbox=-1
ierr=0
while((nbox lt numbox-1) and (ierr ne 4))do begin
cursor,x,y,/down & ierr=!err
if ierr eq 1 then begin
	nbox=nbox+1
	box_x[*,nbox]=x
	box_y[*,nbox]=y
;	Use 10 or 6 here
	device,set_graphics_function=6
	while((ierr ne 2) and (ierr ne 4)) do begin
		cursor,x,y,/change & ierr=!err
		plots,box_x[*,nbox],box_y[*,nbox],psym=0
		box_x[1:2,nbox]=x & box_y[2:3,nbox]=y
		plots,box_x[*,nbox],box_y[*,nbox],psym=0
	endwhile
	device,set_graphics_function=3
endif
if ierr eq 2 then begin
	if nbox ge 0 then begin
		device,set_graphics_function=6
		while((ierr ne 1) and (ierr ne 4)) do begin
			x0=x & y0=y
			cursor,x,y,/change & ierr=!err
			plots,box_x[*,nbox],box_y[*,nbox],psym=0
			box_x[*,nbox]=box_x[*,nbox]+x-x0
			box_y[*,nbox]=box_y[*,nbox]+y-y0
			plots,box_x[*,nbox],box_y[*,nbox],psym=0
		endwhile
		device,set_graphics_function=3
	endif
endif
if nbox ge 0 then begin
	if box_x[1,nbox] lt box_x[0,nbox] then begin
		box_x[*,nbox]=shift(box_x[*,nbox],-2)
		box_x[3,nbox]=box_x[4,nbox]
	endif
	if box_y[2,nbox] gt box_y[1,nbox] then begin
		box_y[*,nbox]=shift(box_y[*,nbox],-2)
		box_y[4,nbox]=box_y[0,nbox]
	endif
endif
endwhile
icom=ierr
nbox=nbox+1
return,icom
;
if boxmode eq 0 then begin
	icom=cw_form('0,LIST,Delete inside boxes|Delete outside boxes|Start over again|
	icom=icom.tag0+1
	if icom.tag0 eq 3 then begin
		device,set_graphics_function=6
		for i=0,nbox do plots,box_x[*,i],box_y[*,i],psym=0
		device,set_graphics_function=3
;   		goto,boxes
	endif
endif else icom=ierr
if icom eq 4 then begin
	device,set_graphics_function=6
	for i=0,nbox do plots,box_x[*,i],box_y[*,i],psym=0
	device,set_graphics_function=3
endif
return,icom
;
end
