function set_caldata,item,outbeam,channel,baseline,x_index,x_mid,x_scl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns data of selected calibration indicators. Note that the units are not
; necessarily the same as the ones returned by set_plotdata. This function
; can also be used to set/determine the scaling parameters of the variables for
; normalization purposes. These will approximately transform the range into
; the interval [-1,1]
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
RAD=180/pi_circle
x_mid=0.0
x_scl=1.0
;
case item of
	1:begin
;	  Wavelength [mu]
	  data=fltarr(n_elements(x_index))+ $
	       float(GenConfig.Wavelength[channel,outbeam]*1.0e6)
	  x_mid=0.68
	  x_scl=6.0
	  end
	2:begin
;	  Delay jitter [mu]
	  data=scans[x_index].DelayJitter(outbeam,baseline)*1e6
	  error=scans[x_index].DelayJitterErr(outbeam,baseline)*1e6
	  index=where(error gt 0,count)
	  if count gt 0 then begin
		x_mid=(min(data[index])+max(data[index]))/2
		x_scl=2/(max(data[index])-min(data[index]))
	  endif else begin
	  	x_mid=3.0
	  	x_scl=0.7
	  endelse
	  end
	3:begin
;	  Tracking jitter [Airy disk diameter?]
	  i=where(GenConfig.StationId eq $
	   strmid(GenConfig.BaselineId[baseline,outbeam],0,3))
	  j=where(GenConfig.StationId eq $
	   strmid(GenConfig.BaselineId[baseline,outbeam],4,3))
	  data=sqrt(scans[x_index].NATJitter(i)^2+scans[x_index].NATJitter(j)^2)
	  rate=scans[x_index].photonrate(outbeam,channel)
	  tjc=genconfig.trackcal[*,baseline,channel,outbeam,0]
	  if total(abs(tjc)) eq 0 then tjc=[1.0,0.0,0.0]
	  data=data/poly(rate,tjc)
	  sign=fltarr(n_elements(x_index))+1
	  index=where(scans[x_index].NATJitterErr(i) lt 0 $
		   or scans[x_index].NATJitterErr(j) lt 0,count)
	  if count gt 0 then sign[index]=-1
	  error=sqrt(scans[x_index].NATJitter(i)^2 $
	  	    +scans[x_index].NATJitter(j)^2)*sign
	  index=where(error gt 0,count)
	  if count gt 0 then begin
		x_mid=(min(data[index])+max(data[index]))/2
		x_scl=2/(max(data[index])-min(data[index]))
	  endif else begin
	  	x_mid=0.25
	  	x_scl=30.0
	  endelse
	  end
	4:begin
;	  Zenith angle [rad]
	  data=float(scans[x_index].ZA/RAD)
	  x_mid=30/RAD
	  x_scl=2/(60/RAD)
	  x_mid=(min(data)+max(data))/2
	  x_scl=2/(max(data)-min(data))
	  end
	5:begin
;	  Mirror angle [rad]
	  data=float(scans[x_index].MA/RAD)
	  x_mid=60/RAD
	  x_scl=2/(80/RAD)
	  x_mid=(min(data)+max(data))/2
	  x_scl=2/(max(data)-min(data))
	  end
	6:begin
;    	  Hour angle [h]
	  data=float(scans[x_index].HA)
	  x_mid=0.5
	  x_scl=0.3
	  x_mid=(min(data)+max(data))/2
	  x_scl=2/(max(data)-min(data))
	  end
	7:begin
;	  Time [h]
	  data=float(abs(scans[x_index].time)/3600)
	  index=where(data gt 0,count)
	  if count gt 1 then begin
		x_mid=(min(data[index])+max(data[index]))/2
		x_scl=2/(max(data[index])-min(data[index]))
	  endif else begin
	    	x_mid=7.6
	    	x_scl=0.25
	  endelse
	  end
    else: begin
	  print,'***Error[SET_CALDATA]: item not allowed: ',item
	  x_scl=0.0
	  return,-1
	  end
endcase
;
return,data
;
end
