pro set_calentries,entries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize cal_entries with entries.
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
;
n=n_elements(entries)
if n eq 0 then begin
	print,'***Error(SET_CALENTRIES): entries undefined!'
	return
endif
create_calentries
;
if n gt n_elements(cal_entries) then begin
	create_calentries,n
	print,'Warning(SET_CALENTRIES): Had to increase table size!'
endif
;
m1=min([n_elements(cal_entries[0].stars),n_elements(entries[0].stars)])
m2=min([n_elements(cal_entries[0].scans),n_elements(entries[0].scans)])
;
tags=tag_names(entries)
for i=0,n_tags(entries)-1 do begin
case tags[i] of
	'VARIABLE':	cal_entries[0:n-1].variable=entries.variable
	'REASON':	cal_entries[0:n-1].reason=entries.reason
	'OUTBEAM':	cal_entries[0:n-1].outbeam=entries.outbeam
	'TRIPLE':	cal_entries[0:n-1].triple=entries.triple
	'BASELINE':	cal_entries[0:n-1].baseline=entries.baseline
	'CHANNEL':	cal_entries[0:n-1].channel=entries.channel
	'STARS':	cal_entries[0:n-1].stars(0:m1-1)=entries[0:n-1].stars(0:m1-1)
	'SCANS':	cal_entries[0:n-1].scans(0:m2-1)=entries[0:n-1].scans(0:m2-1)
	'CALSTARS':	cal_entries[0:n-1].calstars(0:m1-1)=entries[0:n-1].calstars(0:m1-1)
	'INDICATORS':	cal_entries[0:n-1].indicators=entries.indicators
	'FUNCTIONS':	cal_entries[0:n-1].functions=entries.functions
	'COEFFS':	cal_entries[0:n-1].coeffs=entries.coeffs
	'X_MID':	cal_entries[0:n-1].x_mid=entries.x_mid
	'X_SCL':	cal_entries[0:n-1].x_scl=entries.x_scl
	'NUM_INDCT':	cal_entries[0:n-1].num_indct=entries.num_indct
	'NUM_FUNCN':	cal_entries[0:n-1].num_funcn=entries.num_funcn
	'NUM_COEFFS':	cal_entries[0:n-1].num_coeffs=entries.num_coeffs
	'NUM_SCANS':	cal_entries[0:n-1].num_scans=entries.num_scans
	else:		print,'***Error(SET_CALENTRIES): unknown tag (',tags[i],')!'
endcase
endfor
;
end
