pro set_complexvis,multiple=multiple,triple=triple, $
	weight=weight,photometry=photometry,zerophase=zerophase
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use squared visibility and triplephase to set the complex visibility for
; imaging. For NPOI it is assumed that all spectrometers have an identical
; channel layout so that a loop over all triples will initialize all baselines.
; Otherwise it would be non-trivial to determine the common solution
; baselines. Uses SVD to compute solution which satisfies all closure
; phases.
;
; If the spectrometers are different, assume one triple for all (e.g. AMBER).
; For data without triples, just set all phases to zero.
;
; multiple=1: do all nights
; triple=1: drop unconstrained baselines, else use model phases (default=1)
; weight=1: only initialize the complex visibility weights
; photometry=1: use model photometry to set photometry if none is available
; zerophase=1: all phases set to zero, do not solve!
;
; From Monnier, in Principles of Stellar Interferometry, ed. P. Lawson
; CLP(1-2-3) = CLP(1-2-n) + CLP(n-2-3) + CLP(1-n-3)
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Tables,ScanTable,BGTable,StationTable
;
if n_elements(multiple) eq 0 then multiple=0
if n_elements(triple) eq 0 then triple=1
if n_elements(weight) eq 0 then weight=0
if n_elements(zerophase) eq 0 then zerophase=0
if n_elements(photometry) eq 0 then photometry=0
;
if multiple then nights=geninfo.date else nights=genconfig.date
;
FOR night=0,n_elements(nights)-1 DO BEGIN
;
if n_elements(nights) gt 1 then $
loadnight,GenInfo[night[0]].date, $
	  GeoInfo[night[0]].systemid, $
	  GenInfo[night[0]].configid
;
if checkdata([8,9]) ne 0 then return
numscan=n_elements(scans)
;
vis=sqrt(abs(scans.vissqc))
phase=vis*0	; to be used if there are no triples
scans.complexweight=scans.vissqcerr gt 0
;
IF genconfig.numtriple GE 1 AND not keyword_set(zerophase) THEN BEGIN
;
scans.complexweight=0
;
; Check channel and spectrometer layout (by #channels only!)
nc=genconfig.triplenumchan[0]
index=where(genconfig.triplenumchan[0:genconfig.numtriple-1] ne nc,count1)
index=where(genconfig.numspecchan[0:genconfig.numoutbeam-1] ne nc,count2)
if count1 eq 0 and count2 eq 0 then begin
	single_spec=1
endif else begin
	single_spec=0
endelse
;
baselines=unique(genconfig.baselineid[*,0:genconfig.numoutbeam-1])
;
fBaseMatrix=intarr(GenConfig.NumSid,3)
fBaseFactor=fltarr(3,genconfig.numtriple)+1
for i=0,GenConfig.NumTriple-1 do begin
;
fBaseMatrix[*]=0
for l=0,2 do begin
	ob=GenConfig.TripleBeam[l,i]
	bl=GenConfig.TripleBase[l,i]
	j1=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[bl,ob],0,3))
	j2=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[bl,ob],4,3))
	fBaseMatrix[j1,l]=+1
	fBaseMatrix[j2,l]=-1
	if l gt 0 then $
	fBaseFactor[l,i]=(-total(fBaseMatrix[*,0]*fBaseMatrix[*,l]) gt 0)*2-1.0
endfor
;
endfor
;
IF single_spec THEN BEGIN
;
; This code for NPOI or any other single-spectrometer layout
print,'Single-spectrometer setup detected.'
;
nc=genconfig.numspecchan[0]
rms=fltarr(nc,numscan)
chi=fltarr(nc,numscan)
nrm=intarr(nc,numscan)
;
for n=0,numscan-1 do begin
for j=0,nc-1 do begin
	nr=0
	dm=dblarr(genconfig.numtriple,n_elements(baselines))
	rm=dblarr(genconfig.numtriple)
	re=dblarr(genconfig.numtriple)
	ch=GenConfig.TripleChan[j,0,0] ; assume that all channels correspond
;	Compute dm (design matrix) and rm (right hand side)
	for i=0,genconfig.numtriple-1 do begin
		rm[nr]=scans[n].triplephasec(i,j)
		re[nr]=scans[n].triplephasecerr(i,j)
		for l=0,2 do begin
			ob=GenConfig.TripleBeam[l,i]
			ch=GenConfig.TripleChan[j,l,i]
			bl=GenConfig.TripleBase[l,i]
			dm[nr,where(baselines eq genconfig.baselineid[bl,ob])] $
			=fBaseFactor[l,i]
		endfor
		if scans[n].triplephasecerr(i,j) gt 0 then nr=nr+1
	endfor
;	Solve for baseline phases
	if nr eq 0 then $
		print,'No solution for scan '+string(n+1,format='(i3)') $
			+', channel '+string(j+1,format='(i4)')
	if nr gt 0 then begin
		dm=dm[0:nr-1,*]
		rm=rm[0:nr-1]
		re=re[0:nr-1]
		svd8,dm,w,u,v
		small=where(w lt 0.01,count)
		if count gt 0 then w[small]=0
		svb8,u,w,v,rm,s
		for ob=0,genconfig.numoutbeam-1 do begin
		for bl=0,genconfig.numbaseline[ob]-1 do begin
			phase[ob,ch,bl,n] $
			=s[where(baselines eq genconfig.baselineid[bl,ob])]
			if scans[n].vissqcerr(ob,j,bl) gt 0 then $
			scans[n].complexweight(ob,j,bl)=1
		endfor
		endfor
		nrm[j,n]=n_elements(rm)
		if nrm[j,n] ge 3 then rms[j,n]=stddev(rm-dm#s)
		if nrm[j,n] ge 3 then chi[j,n]=mean(((rm-dm#s)/re)^2)
		index=where(scans[n].triplephasecerr(*,j) gt 0,count)
		scans[n].triplephasem(index,j)=dm#s
	endif else if not triple then begin
;	If calcmodel has been run before, keep single baselines
		for ob=0,genconfig.numoutbeam-1 do begin
		for bl=0,genconfig.numbaseline[ob]-1 do begin
			phase[ob,ch,bl,n]=cphase(scans[n].complexvis(ob,j,bl))
			if scans[n].vissqcerr(ob,j,bl) gt 0 then $
			scans[n].complexweight(ob,j,bl)=1
		endfor
		endfor
	endif
;
endfor
endfor
index=where(rms ne 0,count)
if count ge 1 and not weight then begin
	print,'Number of solutions (single-spectrometer layout):',count
	print,'Average phase solution RMS: [deg]',median(rms[index])*180/!pi
	print,'Average phase solution Chi: [deg]',median(chi[index])
endif
;
ENDIF ELSE BEGIN
;
; This code for multiple-spectrometer layouts
print,'Multi-spectrometer setup detected.'
;
; Sanity check
if n_elements(unique(total(genconfig.triplebeam,1))) ne genconfig.numoutbeam $
then begin
	print,'***ERROR: inconsistent triple combinations layout!'
	return
endif else triplebeam=reform(genconfig.triplebeam[0,0:genconfig.numtriple-1])
;
index_blob=intarr(max(genconfig.numbaseline),genconfig.numoutbeam)
for k=0,genconfig.numoutbeam-1 do begin
	for l=0,genconfig.numbaseline[k]-1 do $
		index_blob[l,k]=where(baselines eq genconfig.baselineid[l,k])
endfor
;
nc=max(genconfig.numspecchan)
rms=fltarr(nc,numscan,genconfig.numoutbeam)
chi=fltarr(nc,numscan,genconfig.numoutbeam)
nrm=intarr(nc,numscan,genconfig.numoutbeam)
;
for k=0,genconfig.numoutbeam-1 do begin
	nc=genconfig.numspecchan[k]
	index=where(triplebeam eq k,nt)
for n=0,numscan-1 do begin
for j=0,nc-1 do begin
	nr=0
	dm=fltarr(nt,n_elements(baselines))
	rm=fltarr(nt)
	re=fltarr(nt)
	ch=GenConfig.TripleChan[j,0,index[0]]
;	Compute rm (right hand side) and dm (design matrix)
	for i=0,nt-1 do begin
		if scans[n].triplephasecerr(index[i],j) gt 0 then begin
		rm[nr]=scans[n].triplephasec(index[i],j)
		re[nr]=scans[n].triplephasecerr(index[i],j)
		for l=0,2 do begin
			ob=GenConfig.TripleBeam[l,index[i]]
			bl=GenConfig.TripleBase[l,index[i]]
			dm[nr,index_blob[bl,ob]]=fBaseFactor[l,index[i]]
		endfor
		nr=nr+1
		endif
	endfor
;	Solve for baseline phases
	if nr gt 0 then begin
		dm=dm[0:nr-1,*]
		rm=rm[0:nr-1]
		re=re[0:nr-1]
		svd8,dm,w,u,v
		small=where(w lt 0.01,count)
		if count gt 0 then w[small]=0
		svb8,u,w,v,rm,s
		for bl=0,genconfig.numbaseline[k]-1 do begin
			phase[k,ch,bl,n]=s[index_blob[bl,k]]
			if scans[n].vissqcerr(k,j,bl) gt 0 then $
			scans[n].complexweight(k,j,bl)=1
		endfor
		nrm[j,n,k]=n_elements(rm)
		if nrm[j,n,k] ge 3 then rms[j,n,k]=stddev(rm-dm#s)
		if nrm[j,n,k] ge 3 then chi[j,n,k]=mean(((rm-dm#s)/re)^2)
	endif else if not triple then begin
;		If calcmodel has been run before, keep single baselines
		for bl=0,genconfig.numbaseline[k]-1 do begin
			phase[k,ch,bl,n]=cphase(scans[n].complexvis(k,j,bl))
			if scans[n].vissqcerr(k,j,bl) gt 0 and $
			   nrm[j,n,k] ne 0 then $
			scans[n].complexweight(k,j,bl)=1
		endfor
	endif
;
endfor
endfor
endfor
index=where(rms ne 0,count)
if count ge 1 and not weight then begin
	print,'Number of solutions (multi-spectrometer layout):',count
	print,'Average phase solution RMS: [deg]',median(rms[index])*180/!pi
	print,'Average phase solution Chi: [deg]',median(chi[index])
endif
;
ENDELSE
;
ENDIF	; Triples
;
if not weight then begin
	real_vis=cos(phase)*vis
	imag_vis=sin(phase)*vis
	scans.complexvis=complex(real_vis,imag_vis)
	if photometry then begin
		scans.photometry=scans.photometrym
		print,'Photometry taken from model.'
	endif
endif
;
if n_elements(bufferinfo) gt 1 then $
storenight,11L
;
ENDFOR
;
if not weight then print,'ComplexVis set.'
;
end
