pro set_complexweight,multiple=multiple,triple=triple
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Set complex visibility weights by calling set_complexvis with weight option.
; Complex visibilities remain unaltered. The weights are derived from the
; errors of the triple products for amplitude and phase (triple=1), or from
; the errors of the calibrated (squared) visibilities (triple=0). Therefore,
; in the former case, only baselines which are part of triples are kept.
;
; multiple=1: do all nights
; triple=1: keep baselines not part of any triple, default is triple=0!
;
if n_elements(multiple) eq 0 then multiple=0
if n_elements(triple) eq 0 then triple=0
if n_elements(weight) eq 0 then weight=0
;
set_complexvis,/weight,multiple=multiple,triple=triple
;
end
