pro set_compltriple
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Discard the currently uncalibrated ComplTriple from CHAMELEON and replace with
; vector with phase equal to the (calibrated) TriplePhase and length equal to
; the triple amplitude. This procedure should only be called by marquardtdata.
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ModelFit,parameters,ds_options
;
; Check if only closure phases are relevant
skans=scans	; Temporary copy to use for TripleAmpC values
index=where(scans.tripleampcerr gt 0,count_ta)
if count_ta eq 0 or not ds_options.ta then begin
	skans.tripleampc=scans.tripleampm
	skans.tripleampcerr=1
endif
;
FOR i=0,GenConfig.NumTriple-1 DO BEGIN
;
; Real part
result=reform( $
	cos(scans[*].triplephasec(i,0:GenConfig.TripleNumChan[i]-1)) $
	*skans[*].tripleampc(i,0:GenConfig.TripleNumChan[i]-1), $
	1,1,GenConfig.TripleNumChan[i],n_elements(scans))
if GenConfig.TripleNumChan[i] eq 1 then result=reform(result,1,n_elements(scans)
scans[*].compltriple(i,0,0:GenConfig.TripleNumChan[i]-1)=result
;
; Imaginary part
result=reform( $
	sin(scans[*].triplephasec(i,0:GenConfig.TripleNumChan[i]-1)) $
	*skans[*].tripleampc(i,0:GenConfig.TripleNumChan[i]-1), $
	1,1,GenConfig.TripleNumChan[i],n_elements(scans))
if GenConfig.TripleNumChan[i] eq 1 then result=reform(result,1,n_elements(scans)
scans[*].compltriple(i,1,0:GenConfig.TripleNumChan[i]-1)=result
;
; Error mask
emask=fltarr(GenConfig.TripleNumChan[i]*n_elements(scans))+1
index=where(skans[*].tripleampcerr(i,0:GenConfig.TripleNumChan[i]-1) lt 0 $
         or scans[*].triplephasecerr(i,0:GenConfig.TripleNumChan[i]-1) lt 0,coun
if count gt 0 then emask[index]=-1
emask=reform(emask,1,1,GenConfig.TripleNumChan[i],n_elements(scans))
;
; Error of real part
; Previous computation, to be used with previous in marquardtdata
; result=reform( $
; 	sqrt(abs(sin(scans(*).triplephasec(i,0:GenConfig.TripleNumChan(i)-1)) $
; 			*scans(*).triplephasecerr(i,0:GenConfig.TripleNumChan(i)-1) $
; 			*skans(*).tripleampc(i,0:GenConfig.TripleNumChan(i)-1))^2 $
; 	   +(cos(scans(*).triplephasec(i,0:GenConfig.TripleNumChan(i)-1)) $
;		*skans(*).tripleampcerr(i,0:GenConfig.TripleNumChan(i)-1))^2), $
; 	1,1,GenConfig.TripleNumChan(i),n_elements(scans))*emask
; New computation based on Buscher's Theorem
result=reform( $
	abs(skans[*].tripleampcerr(i,0:GenConfig.TripleNumChan[i]-1)), $
	1,1,GenConfig.TripleNumChan[i],n_elements(scans));*emask
index=where(emask lt 0,count)
if count gt 0 then result[index]=-1
;
if GenConfig.TripleNumChan[i] eq 1 then result=reform(result,1,n_elements(scans)
scans[*].compltripleerr(i,0,0:GenConfig.TripleNumChan[i]-1)=result
;
; Error of imaginart part
; Previous computation, to be used with previous in marquardtdata
; result=reform( $
; 	sqrt(abs(cos(scans(*).triplephasec(i,0:GenConfig.TripleNumChan(i)-1)) $
; 			*scans(*).triplephasecerr(i,0:GenConfig.TripleNumChan(i)-1) $
; 			*skans(*).tripleampc(i,0:GenConfig.TripleNumChan(i)-1))^2 $
; 	   +(sin(scans(*).triplephasec(i,0:GenConfig.TripleNumChan(i)-1)) $
;		*skans(*).tripleampcerr(i,0:GenConfig.TripleNumChan(i)-1))^2), $
; 	1,1,GenConfig.TripleNumChan(i),n_elements(scans))*emask
; New computation based on Buscher's Theorem
result=reform( $
	abs(tan(scans[*].triplephasecerr(i,0:GenConfig.TripleNumChan[i]-1)) $
		*skans[*].tripleampc(i,0:GenConfig.TripleNumChan[i]-1)), $
	1,1,GenConfig.TripleNumChan[i],n_elements(scans));*emask
index=where(emask lt 0,count)
if count gt 0 then result[index]=-1
;
if GenConfig.TripleNumChan[i] eq 1 then result=reform(result,1,n_elements(scans)
scans[*].compltripleerr(i,1,0:GenConfig.TripleNumChan[i]-1)=result
;
; If only closure phases are relevant, circularize error ellipses
if count_ta eq 0 or not ds_options.ta then $
scans(*).compltripleerr(i,0,0:GenConfig.TripleNumChan[i]-1)=result
;
ENDFOR
;
end
