pro set_compltriplem
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Similar to set_compltriplem, but using TripleAmpM and TriplePhaseM.
; Only used after medianob if no model is loaded and before outliers.
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ModelFit,parameters,ds_options
;
FOR i=0,GenConfig.NumTriple-1 DO BEGIN
;
; Real part
result=reform( $
	cos(scans[*].triplephasem(i,0:GenConfig.TripleNumChan[i]-1)) $
	*scans[*].tripleampm(i,0:GenConfig.TripleNumChan[i]-1), $
	1,1,GenConfig.TripleNumChan[i],n_elements(scans))
if GenConfig.TripleNumChan[i] eq 1 then result=reform(result,1,n_elements(scans)
scans[*].compltriplem(i,0,0:GenConfig.TripleNumChan[i]-1)=result
;
; Imaginary part
result=reform( $
	sin(scans[*].triplephasem(i,0:GenConfig.TripleNumChan[i]-1)) $
	*scans[*].tripleampm(i,0:GenConfig.TripleNumChan[i]-1), $
	1,1,GenConfig.TripleNumChan[i],n_elements(scans))
if GenConfig.TripleNumChan[i] eq 1 then result=reform(result,1,n_elements(scans)
scans[*].compltriplem(i,1,0:GenConfig.TripleNumChan[i]-1)=result
;
ENDFOR
;
end
