pro set_h_steps,file
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; One-time initialization of optimal parameter steps for computing the
; numerical derivatives given the data and a model. Instructions: read all
; data, then call this procedure with the name of the model file.
; The observed data are overwritten with model data during this procedure,
; therefore the former have to be reloaded after calling this procedure!
;
forward_function genparms,starparms,binparms,posparms
;
common ModelFit,parameters,ds_options
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(file) eq 0 then begin
	print,'Must specify output file for set_h_steps!'
	return
endif
;
; Determine if the binary fit uses orbit or relative component positions
index=where(parameters.names eq 'Rho' or parameters.names eq 'Theta',count)
if count ge 1 then orbit=0 else orbit=1
;
; Save copy of current parameters
parameters_bck=parameters
;
if init_modelfit() ne 0 then return
if init_fitinterferometry() ne 0 then return
;
parameters[0].component=systemcomp()
parameters[0].names=genparms()
;
for i=0,num_star()-1 do begin
	parameters[i+1].component=star_model[i].component
	parameters[i+1].names=starparms()
endfor
;
for i=0,num_binary()-1 do begin
	parameters[i+1+num_star()].component=binary_model[i].component
	if orbit then parameters[i+1+num_star()].names=binparms() $
		 else parameters[i+1+num_star()].names=posparms()
endfor
;
calcmodel,/quiet
if ds_options.i then mockdata
if ds_options.a then begin
	positions.rho=positions.rhom
	positions.theta=positions.thetam
endif
if ds_options.s then velocities.value=velocities.valuem
;
modelparmcopy,-1,a,/init
;
save,gen_error,star_error,binary_error,filename=file
;
parameters=parameters_bck
;
end
