function set_indexsel,stream,quiet=quiet
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function is called after the user has entered SelDirectives, i.e.
; directives and selections for a particular stream (x, y, or z). It prepares
; the final data selection and stores it in DataSelInfo.
;
; Note a pecularity regarding the star and scan/point selection, since both
; effectively select data point. The star selection is applied after the scan
; selection, i.e. data for a star selected, if no scans corresponding to this
; star have been selected too, will not have data selected. In addition, this
; selection has additional directives related to the scan configuration, i.e.
; configurations which differ only by their stations used. This feature is
; required by the 6-way observing configuration.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
;
if not keyword_set(quiet) then quiet=0
;
flag=0
if n_elements(x_dir) eq 0 then flag=1
if n_elements(y_dir) eq 0 then flag=1
if n_elements(z_dir) eq 0 then flag=1
if n_elements(x_sel) eq 0 then flag=1
if n_elements(y_sel) eq 0 then flag=1
if n_elements(z_sel) eq 0 then flag=1
if flag then begin
	print,'***Error(SET_INDEXSEL): some directives/selections undefined!'
	return,-1
endif
;
case stream of
	'x':begin
	    ch_dir=x_dir.ch
	    bl_dir=x_dir.bl
	    tr_dir=x_dir.tr
	    pt_dir=x_dir.pt
	    ch_sel=x_sel.ch
	    bl_sel=x_sel.bl
	    pt_sel=x_sel.pt
	    end
	'y':begin
	    ch_dir=y_dir.ch
	    bl_dir=y_dir.bl
	    tr_dir=y_dir.tr
	    pt_dir=y_dir.pt
	    ch_sel=y_sel.ch
	    bl_sel=y_sel.bl
	    pt_sel=y_sel.pt
	    end
	'z':begin
	    ch_dir=z_dir.ch
	    bl_dir=z_dir.bl
	    tr_dir=z_dir.tr
	    pt_dir=z_dir.pt
	    ch_sel=z_sel.ch
	    bl_sel=z_sel.bl
	    pt_sel=z_sel.pt
	    end
endcase
; NoTrace option not selected (default): X-selection will trace Y-selection
if stream eq 'x' and not ps_options.t then begin
	    ch_dir=y_dir.ch
	    bl_dir=y_dir.bl
	    tr_dir=y_dir.tr
	    pt_dir=y_dir.pt
	    ch_sel=y_sel.ch
	    bl_sel=y_sel.bl
	    pt_sel=y_sel.pt
endif
set_streamsel,stream,item,ds_ib,ds_ob,ds_tr,ds_ch,ds_bl,ds_pt
;
if n_elements(ds_ib) eq 0 then return,-1
if n_elements(ds_ob) eq 0 then return,-1
if n_elements(ds_tr) eq 0 then return,-1
if (ds_ib lt 0) or $
   (ds_ib ge GenConfig.NumSid and GenConfig.NumSid ne 0) then begin
	print,'***Error(SET_INDEXSEL): invalid input beam selection!'
	return,-1
endif
if (ds_ob lt 0) or $
   (ds_ob ge GenConfig.NumOutBeam and GenConfig.NumOutBeam ne 0) then begin
	print,'***Error(SET_INDEXSEL): invalid output beam selection!'
	return,-1
endif
if (ds_tr lt 0) or $
   (ds_tr ge GenConfig.NumTriple and GenConfig.NumTriple ne 0) then begin
  	if item ge 28 and item le 33 then begin
	print,'***Error(SET_INDEXSEL): invalid triple selection!'
	return,-1
	endif
endif
;
flag=0
if n_elements(ch_dir) eq 0 then flag=1
if n_elements(bl_dir) eq 0 then flag=1
if n_elements(pt_dir) eq 0 then flag=1
if flag then begin
	print,'***Error(SET_INDEXSEL): one or more directives undefined!'
	return,-1
endif
;
; Prepare channel selection
;
if ch_dir eq 'All' then begin
	check=[6,7,28,29,30,31,32,33,58,59]
	if long(where(check eq item),0) ne -1 and GenConfig.NumTriple ge 1 $
	then ds_ch=indgen(GenConfig.TripleNumChan[ds_tr]) $
	else ds_ch=indgen(GenConfig.NumSpecChan[ds_ob])
endif else if ch_dir eq 'Selected' then begin
	if max(ch_sel) eq 0 then begin
		print,'***Error(SET_INDEXSEL): no channels selected!'
		return,-1
	endif
	ds_ch=ch_sel[where(ch_sel ne 0)]-1
endif else if ch_dir eq 'Next' then begin
	index=where(ch_sel ne 0,n)
	if n_elements(ds_ch) eq 0 then begin
		if n eq 0 then begin
		  print,'***Error(SET_INDEXSEL): '+ $
			'you have to enter channel selection first!'
		  return,-1
		endif
		ds_ch=indgen(n)
	endif else ds_ch=ds_ch+n
endif else if ch_dir eq 'Previous' then begin
	n=n_elements(ds_ch)
	if n eq 0 then begin
		print,'***Error(SET_INDEXSEL): no channels currently selected'
		return,-1
	endif
	ds_ch=ds_ch-n
endif
if n_elements(ds_ch) eq 0 then begin
	print,'***Error(SET_INDEXSEL): no channels selected!'
	return,-1
endif
;
; Prepare baseline selection
;
if bl_dir eq 'All' then begin
	ds_bl=indgen(GenConfig.NumBaseline[ds_ob])
endif else if bl_dir eq 'Selected' then begin
	if max(bl_sel) eq 0 then begin
		print,'***Error(SET_INDEXSEL): no baselines selected!'
		return,-1
	endif else ds_bl=bl_sel[where(bl_sel ne 0)]-1
endif else if bl_dir eq 'Next' then begin
	index=where(bl_sel ne 0,n)
	if n_elements(ds_bl) eq 0 then begin
		if n eq 0 then begin
		  print,'***Error(SET_INDEXSEL): '+ $
			'you have to enter baseline selection first!'
		  return,-1
		endif
		ds_bl=indgen(n)
	endif else ds_bl=ds_bl+n
endif else if bl_dir eq 'Previous' then begin
	n=n_elements(ds_bl)
	if n eq 0 then begin
		print,'***Error: no baselines currently selected'
		return,-1
	endif
	ds_bl=ds_bl-n
endif
if n_elements(ds_bl) eq 0 then begin
	print,'***Error(SET_INDEXSEL): no baselines selected!'
	return,-1
endif
;
; Prepare triple selection
;
if 0 then begin
if tr_dir eq 'All' then begin
	ds_tr=indgen(GenConfig.NumBaseline[ds_ob])
endif else if tr_dir eq 'Selected' then begin
	if max(tr_sel) eq 0 then begin
		print,'***Error(SET_INDEXSEL): no triples selected!'
		return,-1
	endif else ds_tr=tr_sel[where(tr_sel ne 0)]-1
endif else if tr_dir eq 'Next' then begin
	index=where(tr_sel ne 0,n)
	if n_elements(ds_tr) eq 0 then begin
		if n eq 0 then begin
		  print,'***Error(SET_INDEXSEL): '+ $
			'you have to enter triple selection first!'
		  return,-1
		endif
		ds_tr=indgen(n)
	endif else ds_tr=ds_tr+n
endif else if tr_dir eq 'Previous' then begin
	n=n_elements(ds_tr)
	if n eq 0 then begin
		print,'***Error: no triples currently selected'
		return,-1
	endif
	ds_tr=ds_tr-n
endif
if n_elements(ds_tr) eq 0 then begin
	print,'***Error(SET_INDEXSEL): no triples selected!'
	return,-1
endif
endif
;
; Prepare point selection
;
parms=init_class(class,datascans)
num_points=n_elements(datascans)
;
if pt_dir eq 'All' then begin
	ds_pt=lindgen(num_points)
endif else if pt_dir eq 'Selected' then begin
	if max(pt_sel) eq 0 then begin
		print,'***Error(SET_INDEXSEL): no points/scans selected!'
		return,-1
	endif
	if max(pt_sel) gt num_points then begin
		print,'***Error(SET_INDEXSEL): invalid point selection!'
		return,-1
	endif
;	ds_pt=pt_sel-1
	ds_pt=pt_sel[where(pt_sel ne 0)]-1
endif else if pt_dir eq 'Next' then begin
	index=where(pt_sel ne 0,n)
	if n_elements(ds_pt) eq 0 then begin
		if n eq 0 then begin
		  print,'***Error(SET_INDEXSEL): '+ $
			'you have to enter point/scan selection first!'
		  return,-1
		endif
		ds_pt=lindgen(n)
	endif else begin
		if n eq 1 and n_elements(ds_stars) eq 1 and class eq 'scan' $
		then begin
;			Search for next scan of selected star
			repeat begin
				ds_pt=ds_pt+n
			endrep until (scantable[ds_pt].starid eq ds_stars $
				  and scantable[ds_pt].code eq 1) $
				   or ds_pt eq num_points
		endif else begin
			ds_pt=max(ds_pt)+indgen(n)+1
;			ds_pt=ds_pt+n_elements(ds_pt)
;			ds_pt=ds_pt(where(ds_pt lt num_points))
		endelse
	endelse
endif else if pt_dir eq 'Previous' then begin
	n=n_elements(ds_pt)
	if n eq 0 then begin
	   print,'***Error(SET_INDEXSEL): no points/scans currently selected'
   	   return,-1
	endif
	ds_pt=ds_pt-n
endif else begin
;	Process sub-array selection
	scanids=scanconfig(pt_dir)
	index=lonarr(num_points)
	for i=0,n_elements(scanids)-1 do begin
		j=where(datascans.iscan eq scanids[i],count)
		if count gt 0 then index[j]=1
	endfor
	if total(index) gt 0 then ds_pt=where(index ne 0)
endelse
if n_elements(ds_pt) eq 0 then begin
	print,'***Error(SET_INDEXSEL): no points/scans selected!'
	return,-1
endif
index=where(ds_pt lt num_points,count)
if count eq 0 then begin
	print,'Invalid data selection!'
	return,-1
endif
ds_pt=ds_pt[index]
if stream eq 'y' then begin
	if strpos(type,'V2Bias') ge 0 then type='V2Bias'+pt_dir
	if strpos(type,'TABias') ge 0 then type='TABias'+pt_dir
	if strpos(type,'APDFlux') ge 0 then type='APDFlux'+pt_dir
	if strpos(type,'Response') ge 0 then type='Response'+pt_dir
	if strpos(type,'TrackJitter') ge 0 then type='TrackJitter'+pt_dir
endif
;
; From the scans/points selected, select those corresponding to selected stars
iscan=lindgen(n_elements(datascans))
stars=datascans[ds_pt].starid
jscan=iscan[ds_pt]
first_star=1
for is=0,n_elements(ds_stars)-1 do begin
	index=where(stars eq ds_stars[is],count)
	if count gt 0 then begin
		if first_star then begin
			pt_star=jscan[index]
			first_star=0
		endif else pt_star=[pt_star,jscan[index]]
	endif else ds_stars[is]=''
endfor
if n_elements(pt_star) gt 0 then ds_pt=pt_star
; Remove those stars from the list that wouldn't produce any data
index=where(strlen(ds_stars) gt 0,count)
if count gt 0 then ds_stars=ds_stars[index]
;
; Do this for classes with data not related to stars
; if class eq 'metro' then pt_star=ds_pt
;
case stream of
	'x':begin
	    if n_elements(ds_bl) gt n_elements(ds_x.bl) $
	    or n_elements(ds_tr) gt n_elements(ds_x.tr) $
	    or n_elements(ds_ch) gt n_elements(ds_x.ch) $
	    or n_elements(ds_pt) gt n_elements(ds_x.pt) then begin
		if reinit_indexsel() ne 0 then return,-1
	    endif
	    ds_x.bl=-1
	    ds_x.tr=-1
	    ds_x.ch=-1
	    ds_x.pt=-1
	    ds_x.bl[0:n_elements(ds_bl)-1]=ds_bl
	    ds_x.tr[0:n_elements(ds_tr)-1]=ds_tr
	    ds_x.ch[0:n_elements(ds_ch)-1]=ds_ch
	    ds_x.pt[0:n_elements(ds_pt)-1]=ds_pt
	    end
	'y':begin
	    if n_elements(ds_bl) gt n_elements(ds_y.bl) $
	    or n_elements(ds_tr) gt n_elements(ds_y.tr) $
	    or n_elements(ds_ch) gt n_elements(ds_y.ch) $
	    or n_elements(ds_pt) gt n_elements(ds_y.pt) then begin
		if reinit_indexsel() ne 0 then return,-1
	    endif
	    ds_y.bl=-1
	    ds_y.tr=-1
	    ds_y.ch=-1
	    ds_y.pt=-1
	    ds_y.bl[0:n_elements(ds_bl)-1]=ds_bl
	    ds_y.tr[0:n_elements(ds_tr)-1]=ds_tr
	    ds_y.ch[0:n_elements(ds_ch)-1]=ds_ch
	    ds_y.pt[0:n_elements(ds_pt)-1]=ds_pt
	    end
	'z':begin
	    if n_elements(ds_bl) gt n_elements(ds_z.bl) $
	    or n_elements(ds_tr) gt n_elements(ds_z.tr) $
	    or n_elements(ds_ch) gt n_elements(ds_z.ch) $
	    or n_elements(ds_pt) gt n_elements(ds_z.pt) then begin
		if reinit_indexsel() ne 0 then return,-1
	    endif
	    ds_z.bl=-1
	    ds_z.tr=-1
	    ds_z.ch=-1
	    ds_z.pt=-1
	    ds_z.bl[0:n_elements(ds_bl)-1]=ds_bl
	    ds_z.tr[0:n_elements(ds_tr)-1]=ds_tr
	    ds_z.ch[0:n_elements(ds_ch)-1]=ds_ch
	    ds_z.pt[0:n_elements(ds_pt)-1]=ds_pt
	    end
endcase
;
if n_elements(pt_star) eq 0 then begin
	if not quiet then $
		print,'***Error(SET_INDEXSEL): no data for this selection!'
	return,-1
endif else return,0
;
end
