pro set_minerrors,cal_stars_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the calibration error based on *spectral* fluctuations of the
; calibrator visibilities squared and triple amplitudes, and add in
; quadrature to the error of the calibrated visibilities.
; To compute the calibration error, use the EC visibilities to compute
; chisq, and compute the additive error as sqrt((chisq-1)*e^2/z^2), where
; e is the intrinsic error, and z is the calibrated visibility (which is
; not necessarily unity if the calibrator is resolved). The latter two
; are mean quantities, i.e. the average of the values. Other means might
; be considered too (geometric, mean of the squares, etc.). The aim is to
; produce unity chisq for the calibrator data.
;
; Derive selected program and calibrator stars from the selection made
; in the appropriate widgets.
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common StarBase,startable,notes
;
for i=0,n_elements(geninfo.date)-1 do begin
if geoinfo[i].systemid eq 'NPOI' then begin
;
if n_elements(geninfo.date) gt 1 then $
loadnight,geninfo[i].date, $
	  geoinfo[i].systemid, $
	  geninfo[i].configid
index=where(startable.bflag eq 'C')
if n_elements(cal_stars_in) eq 0 then cal_stars=startable[index].starid $
				 else cal_stars=cal_stars_in
ds_stars=startable.starid
;
;
; Obtain scan index corresponding to calibrator star selection
list_stars,stars
mask=intarr(n_elements(scans))
for k=0,n_elements(stars)-1 do begin
        index=where(cal_stars eq stars[k],count)
        if count eq 0 then begin
                index=where(scans.StarId eq stars[k])
                mask[index]=-1
        endif
endfor
calscan_index=where(mask eq 0,calscan_count)
;
; Obtain scan index corresponding to program star selection
list_stars,stars
mask=intarr(n_elements(scans))
for k=0,n_elements(stars)-1 do begin
	index=where(ds_stars eq stars[k],count)
	if count eq 0 then begin
		index=where(scans.StarId eq stars[k])
		mask[index]=-1
	endif
endfor
scan_index=where(mask eq 0,scan_count)
;
; Determine r.m.s. of calibrator in each channel of a spectrometer
for ob=0,GenConfig.NumOutBeam-1 do begin
for bl=0,GenConfig.NumBaseline[ob]-1 do begin
;
v2=fltarr(GenConfig.NumSpecChan[ob],calscan_count)
e2=v2
;
; Compute floating calibration factor for each baseline
for sc=0,calscan_count-1 do begin
	y=scans[calscan_index[sc]].vissqc(ob,*,bl)
	e=scans[calscan_index[sc]].vissqcerr(ob,*,bl)
	e_index=where(e gt 0,count)
	if count eq 0 then continue
	y_e=y[e_index]
	e_e=e[e_index]
	ymodel=y_e*0+1
	if n_elements(ymodel) eq 1 then ymodel=fltarr(1)+ymodel
	nf=140
	f=findgen(nf+1)/100+(1.0-nf/200.) & r=f
	for k=0,nf do r[k]=total(((y_e*f[k]-ymodel)/e_e)^2)
	k=where(r eq min(r)) & k=k[0]
	y=y*f[k]
	e=e*f[k]
	v2[*,sc]=y
	e2[*,sc]=e
endfor
;
; Compute chisq in each channel...
for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
	e_index=where(e2[ch,*] gt 0,count)
	if count eq 0 then continue
	chisq=(total(((v2[ch,e_index]-1)/e2[ch,e_index])^2)/count) > 1
;
; 	...and apply corrections
	w=sqrt(chisq-1)*avg(e2[ch,e_index]/v2[ch,e_index])
	j=where(scans[scan_index].VisSqCErr(ob,ch,bl) lt 0,count)
	scans[scan_index].VisSqCErr(ob,ch,bl)= $
	 sqrt(scans[scan_index].VisSqCErr(ob,ch,bl)^2 $
	    +(scans[scan_index].VisSqC(ob,ch,bl)*w)^2)
	if count gt 0 then begin
		scans[scan_index[j]].VisSqCErr(ob,ch,bl)= $
	       -scans[scan_index[j]].VisSqCErr(ob,ch,bl)
	endif
endfor
;
endfor
endfor
;
; Do the same for triple amplitudes
for tr=0,genconfig.numtriple-1 do begin
;
ta=fltarr(genconfig.triplenumchan[tr],calscan_count)
ea=ta
;
; Compute floating calibration factor for each baseline
for sc=0,calscan_count-1 do begin
	y=scans[calscan_index[sc]].tripleampc(tr,*)
	e=scans[calscan_index[sc]].tripleampcerr(tr,*)
	e_index=where(e gt 0,count)
	if count eq 0 then continue
	y_e=y[e_index]
	e_e=e[e_index]
	ymodel=y_e*0+1
	if n_elements(ymodel) eq 1 then ymodel=fltarr(1)+ymodel
	nf=140
	f=findgen(nf+1)/100+(1.0-nf/200.) & r=f
	for k=0,nf do r[k]=total(((y_e*f[k]-ymodel)/e_e)^2)
	k=where(r eq min(r)) & k=k[0]
	y=y*f[k]
	e=e*f[k]
	ta[*,sc]=y
	ea[*,sc]=e
endfor
;
; Compute chisq in each channel...
for ch=0,genconfig.triplenumchan[tr]-1 do begin
	e_index=where(ea[ch,*] gt 0,count)
	if count eq 0 then continue
	chisq=(total(((ta[ch,e_index]-1)/ea[ch,e_index])^2)/count) > 1
;
; 	...and apply corrections
	w=sqrt(chisq-1)*avg(ea[ch,e_index]/ta[ch,e_index])
	j=where(scans[scan_index].tripleampcerr(tr,ch) lt 0,count)
	scans[scan_index].tripleampcerr(tr,ch)= $
	 sqrt(scans[scan_index].tripleampcerr(tr,ch)^2 $
	    +(scans[scan_index].tripleampc(tr,ch)*w)^2)
	if count gt 0 then begin
		scans[scan_index[j]].tripleampcerr(tr,ch)= $
	       -scans[scan_index[j]].tripleampcerr(tr,ch)
	endif
endfor
endfor
;
if n_elements(bufferinfo) gt 1 then $
storenight,11
;
endif	; NPOI only
endfor	; Next night
;
end
