pro set_parallax,value,error,weight=weight
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Units of parallax are mas. Set weight=0 to have parallax ignored.
; Set the value to a negative number to only enforce equality of parallaxes
; for all binary components.
;
common AuxData,parallaxes,k1,k2,vsini
common ModelFit,parameters,ds_options
;
if n_elements(value) eq 0 then begin
	print,'Usage: set_parallax,value,error,weight=weight'
	print,'Set value to -1 to enforce equality of all parallaxes'
	print,'To remove parallax, set value or weight to zero'
	return
endif
;
if value eq 0 then begin
	parallaxes.value=0
	ds_options.px=0
	return
endif
;
if n_elements(weight) eq 0 then weight=1
if n_elements(parallaxes) eq 0 then parallaxes=alloc_parallax()
;
if weight eq 0 then begin
	ds_options.px=0
	print,'Weight of parallax set to zero.'
	return
endif
if value lt 0 then begin
	ds_options.px=-1
	if n_elements(error) eq 0 then error=1
	parallaxes.error=error
	return
endif
if n_params() ne 2 then begin
	print,'***Error[SET_PARALLAX]: please provide value AND error!'
	return
endif
parallaxes.value=value
parallaxes.error=error
ds_options.px=weight
;
end
