pro set_pionierfree
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Converts configuration of PIONIER data taken with FREE setup from
; single-spec 6-baseline to 6-spec 1-baseline each. This allows to make
; use of the spectral bandpass calibration for each baseline separately.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Pionier,pionier_spectral_cal
;
systemid='VLTI/PIONIER-FREE'
genconfig.beamcombinerid=beamcombiner_id(systemid)
pionier_spectral_cal='generic_c'
;
; Obtain information on IP channels for each baseline
si=sort(genconfig.stationid[0:genconfig.numsid-1])
path=!oyster_dir+'vlti/pionier/'
file=path+strjoin(genconfig.stationid[si],'-')+'_*.txt'
files=file_search(file)
flag=0
if strlen(files[0]) eq 0 then flag=1
mjds=long(strmid(specname(files),16,5))
mjd=long(date2jd(date,/mjd))
index=where(mjds le mjd,count)
if count eq 0 or flag then begin
	print,'VLTI configuration not found for date '+date+': '+file
	print,'Using bandpass data from OIFITS file instead.'
	return
endif
file=files[index[count-1]]
spawn,'cp -f '+path+strtrim(string(mjds[count-1]),1)+'/*.xdr '+path
;
stationid=''
status=dc_read_free(file,/col,stationid,ip,ignore=['!'])
genconfig.bcinputid[si]=ip
;
n=n_elements(scans)
s=scans
g=genconfig
;
r=size(scans.fdlpos,/dim)
numsid=r[0]	; 4
r=size(scans.vissqc,/dim)
numchan=1	; FREE
numbase=1
numout=r[2]	; 6, with one baseline each
r=size(scans.triplephasec,/dim)
numtriple=r[0]
maxconfig=1
;
genconfig=allocgenconfig(numsid,numout,numtriple,numbase,numchan,maxconfig)
genconfig.numsid=numsid
genconfig.numoutbeam=numout
genconfig.numtriple=numtriple
genconfig.numbaseline=numbase
genconfig.numspecchan=numchan
genconfig.stationid=g.stationid
genconfig.stationcoord=g.stationcoord
genconfig.baselineid=g.baselineid
genconfig.date=Date
genconfig.beamcombinerid=g.beamcombinerid
genconfig.diameter=g.diameter
genconfig.wavelength=g.wavelength[0]
genconfig.chanwidth=g.chanwidth[0]
genconfig.bcinputid=g.bcinputid
genconfig.triplebeam=g.triplebase
genconfig.triplenumchan=g.triplenumchan
;
; Copy information from 1-dimensional vectors
scans=replicate(scan(),n)
for i=0,n_tags(scans)-1 do if size(scans.(i),/n_dim) le 1 then scans.(i)=s.(i)
;
; Copy information from multi-dimensional vectors
v=s.vissqc
v=reform(v,numout,1,1,n)
scans.vissqc=v
v=s.vissqcerr
v=reform(v,numout,1,1,n)
scans.vissqcerr=v
uvw=s.uvw
uvw=reform(uvw,numout,1,1,3,n)
scans.uvw=uvw
scans.triplephasec=s.triplephasec
scans.triplephasecerr=s.triplephasecerr
scans.tripleampc=s.tripleampc
scans.tripleampcerr=s.tripleampcerr
;
; The following array indexed by (ob,ch) will contain the filter names
pionier_spectral_cal=strarr(1,genconfig.numoutbeam)
prefix='pionier_free_'
lambda_grid=findgen(150)*2+1500; [nm], H-band
for i=0,genconfig.numoutbeam-1 do begin
	j=where(genconfig.stationid eq strmid(genconfig.baselineid[i],0,3))
	k=where(genconfig.stationid eq strmid(genconfig.baselineid[i],4,3))
	bcid=[genconfig.bcinputid[j],genconfig.bcinputid[k]]
	si=sort(bcid) & bcid=bcid[si]
	filter=prefix+string(bcid[0]*10+bcid[1],format='(i2)')
	pionier_spectral_cal[0,i]=filter
	tm=call_function(filter,lambda_grid)
	genconfig.wavelength[0,i]=(total(lambda_grid*tm)/total(tm))*1e-9
endfor
;
; Set geninfo
geninfo=genconfig
;
; Must recalculate uv-coordinates as spectral bandpasses have changed
calcastrom
;
end
