function set_plotdata,item,ib,ob,tr,ch,bl,pt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given data array indices, return corresponding data for item.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common Tables,ScanTable,BGTable,StationTable
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common SeeingData,scintillation,r0,t0,delayrms,phaserms,delayjitter2,natjitter2
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
ml2cpa=1e6/(RAD*3600)
if item[0] eq 3 or item[0] eq 6 then begin
case system_id(SystemId) of
        'Mark3'   :normfactor=pi_circle^2/2
        'NPOI'    :normfactor=4.0/sinc(float(GenConfig.FringeMod[bl,ob]) $
				       /GenConfig.NumBin)^2
              else:normfactor=1.0
endcase
endif
ibr=GenConfig.RefStation-1
;
; Intercept some common user errors
icheck=0
if long(where([6,7,28,29,30,31,32,33] eq item),0) ne -1 $
	and GenConfig.NumTriple eq 0 then icheck=1
if icheck then begin
	print,'***Error(SET_PLOTDATA): no data to plot!'
	return,-1
endif
;
case item[0] of
;	   Time (pt)		[s] since 0 UT of date
	 1:return,PointTime[pt]/3600
;	   Index (pt)		An index number
	 2:if ps_options.n then return,float(pt)+1 $
			   else return,findgen(n_elements(pt))+1
	 2:return,findgen(n_elements(pt))+1
;	   VisSq (pt)		X^2+Y^2-N
 	 3:return,VisSq[ob,ch,bl,pt]*normfactor $
 		 /nonzero(PhotonRate[ob,ch,pt])^2
;	   FASN (pt)
	 4:return,VisSq[ob,ch,bl,pt]
;	   VisPhase (pt)
	 5:return,VisPhase[ob,ch,bl,pt]*RAD
;	 6:return,TripleAmp(tr,ch,pt)
;	   TripleAmp (pt)
	 6:return,TripleAmp[tr,ch,pt]*normfactor^1.5 $
		 /nonzero(Photonrate[GenConfig.TripleBeam[0,tr], $
				     GenConfig.TripleChan[ch,0,tr],pt] $
		         *PhotonRate[GenConfig.TripleBeam[1,tr], $
				     GenConfig.TripleChan[ch,1,tr],pt] $
			 *PhotonRate[GenConfig.TripleBeam[2,tr], $
				     GenConfig.TripleChan[ch,2,tr],pt])
;	   TriplePhase (pt)
	 7:return,TriplePhase[tr,ch,pt]*RAD
;	   PhotonRate (pt)	/2 ms
	 8:return,PhotonRate[ob,ch,pt]
;	   FDLPath (pt)	[m] of delay added; absolute
	 9:return,FDLPos[ib,pt]+FDLPos[ibr,pt]*(ib ne ibr)
;	   DelayJitter (pt)	RMS
	10:return,DelayJitter[ob,bl,pt]*1000000
;	   NATJitter (pt)
	11:return,NATJitter[ib,pt]
;	   NATCounts (pt)
	12:return,NATCounts[ib,pt]
;	   GrpDelay (pt)	Correction to FDL
	13:return,GrpDelay[ib,pt]
;	   DryDelay (pt)	Correction to FDL
	14:return,DryDelay[ib,pt]
;	   WetDelay (pt)	Correction to FDL
	15:return,WetDelay[ib,pt]
;	   VacDelay (pt)	Fringe tracking delay
	16:return,(FDLPos[ib,pt]*(ib ne ibr)-GeoDelay[ib,pt])*1d6 $
	 	 -DryDelay[ib,pt]
;	   FDLDelay (pt)	[mu] of delay rel. to ref. delay line -sidereal d.
	17:return,(FDLPos[ib,pt]*(ib ne ibr)-GeoDelay[ib,pt])*1e6
;	   MetroDelay (pt)	[mu] of delay relative to reference station
	18:begin
	   if n_elements(MetroPos) le 1 then return,0
	   if ib eq ibr then return,MetroPos[ib,pt]*0 $
			else return,MetroPos[ib,pt]
	   end
;	   Time (BG)
	19:return,bgscans[pt].Time/3600
;	   ScanNo (BG)
	20:return,float(pt)+1
;	   BGRate (BG)
	21:return,bgscans[pt].Rate(ob,ch)
;	   Time (sc)		[s] since 0 UT of date
	22:return,scans[pt].Time/3600
;	   ScanNo (sc)
	23:return,float(pt)+1
;	   VisSq (sc)		<X^2+Y^2-N>/<N-D>^2
	24:return,scans[pt].VisSq(ob,ch,bl)
;	   VisSq c (sc)	calibrated V^2
	25:return,scans[pt].VisSqC(ob,ch,bl)
;	   Diameter based on VisSq c (sc)
;	25:return,hb(sqrt(scans(pt).UVW(ob,ch,bl,0)^2 $
;		         +scans(pt).UVW(ob,ch,bl,1)^2)/1e6, $
;		scans(pt).VisSqC(ob,ch,bl))
;	   VisSq/e (sc)	V^2/estimated V^2
	26:return,scans[pt].VisSqE(ob,ch,bl)
;	   VisSq c/e (sc)	cal. V^2/est. V^2
	27:return,scans[pt].VisSqEC(ob,ch,bl)
;	   TripleAmp (sc)
	28:return,scans[pt].TripleAmp(tr,ch)
;	   TripleAmp c (sc)
	29:return,scans[pt].TripleAmpC(tr,ch)
;	   TripleAmp/e (sc)
	30:return,scans[pt].TripleAmpE(tr,ch)
;	   TripleAmp c/e (sc)
	31:return,scans[pt].TripleAmpEC(tr,ch)
;	   TriplePhase (sc)	Closure phase
	32:return,scans[pt].TriplePhase(tr,ch)*RAD
;	   TriplePhase c (sc)	Calibrated closure phase - n*360
	33:return,scans[pt].TriplePhaseC(tr,ch)*RAD
;	   PhotonRate (sc)	Rate/2 ms - background
	34:return,scans[pt].PhotonRate(ob,ch)
;	   BackgndRate (sc)	/2 ms
	35:return,scans[pt].BackgndRate(ob,ch)
;	   FDLPath (sc) 	[m] of delay added; absolute
	36:return,scans[pt].FDLPos(ib)+scans[pt].FDLPos(ibr)*(ib ne ibr)
;	   DelayJitter (sc)	Based on CONSTRICTOR
	37:return,scans[pt].DelayJitter(ob,bl)*1000000
;	   TrackJitter (sc)   Jitter of NAT1^2+NAT2^2
	38:begin
	   i=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],0,3))
	   j=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],4,3))
	   tjc=genconfig.trackcal[*,bl,ch,ob,0]
	   if total(abs(tjc)) eq 0 then tjc=[1.0,0.0,0.0]
	   return,(sqrt(scans[pt].NATJitter(i)^2 $
		       +scans[pt].NATJitter(j)^2)) $
		/poly(scans[pt].photonrate(ob,ch),tjc)
	   end
;	   FDLDelay (sc)	Delay relative to reference station
	39:return,scans[pt].FDLPos(ib)*(ib ne ibr)
;	   GeoDelay (sc)	Geometric delay - delay offset
	40:return,scans[pt].GeoDelay(ib)
;	   uv-Radius (sc)
;	41:return,sqrt(scans(pt).UVW(ob,ch,bl,0)^2 $
;		      +scans(pt).UVW(ob,ch,bl,1)^2)/1e6*ml2cpa
	41:return,sqrt(scans[pt].UVW(ob,ch,bl,0)^2 $
		      +scans[pt].UVW(ob,ch,bl,1)^2)/1e6
;	   HourAngle
	42:return,scans[pt].HA
;	   ZenithAngle
	43:return,scans[pt].ZA
;	   MirrorAngle	2*angle to mirror normal
	44:return,scans[pt].MA
;	   Wavelength		[mu]
	45:return,GenConfig.Wavelength[ch,ob]*1d6
;	   Channel
	46:return,float(ch)+1
;	   BLlength
	47:return,fltarr(MB)+1
;	   Baseline
	48:return,findgen(MB)+1
;	   Triple
	49:return,findgen(MT)+1
;	   U			[m]
	50:return,scans[pt].UVW(ob,ch,bl,0)/1000000
;	   V			[m]
	51:return,scans[pt].UVW(ob,ch,bl,1)/1000000
;	   W			[m]
	52:return,scans[pt].UVW(ob,ch,bl,2)/1000000
;	   FDL_O-C (sc)
	53:return,(scans[pt].FDLPos(ib)*(ib ne ibr)-scans[pt].GeoDelay(ib))*1e6
;	   Grp_O-C (sc)	FDL+group delay
	54:return,(scans[pt].GrpDelay(ib)-scans[pt].GeoDelay(ib))*1000000
;	   Dry_O-C (sc)	FDL+group delay+dry air correction
	55:return,(scans[pt].DryDelay(ib)-scans[pt].GeoDelay(ib))*1000000
;	   Wet_O-C (sc)	FDL+group delay+wet air correction
	56:return,(scans[pt].WetDelay(ib)-scans[pt].GeoDelay(ib))*1000000
;	   VisSq m (sc)	Model
	57:return,scans[pt].VisSqM(ob,ch,bl)
;	   Diameter based on model visibility
;	57:return,hb(sqrt(scans(pt).UVW(ob,ch,bl,0)^2 $
;		         +scans(pt).UVW(ob,ch,bl,1)^2)/1e6, $
;		scans(pt).VisSqM(ob,ch,bl))
;	   TripleAmp m (sc)	Model
	58:return,scans[pt].TripleAmpM(tr,ch)
;	   TriplePhase m (sc)	Model
	59:return,scans[pt].TriplePhaseM(tr,ch)*RAD
;	   MetroTime (mt)	[s] since 0 UT
	60:return,MetroTime[pt]/3600
;	   Par X (mt)
	61:return,ParX[ib,pt]
;	   Par Y (mt)
	62:return,ParY[ib,pt]
;	   Par Z (mt)
	63:return,ParZ[ib,pt]
;	   MetroPath (mt)
	64:return,MetroPath[ib,pt]
;	   MetroDelay (mt)
	65:begin
	   if ib eq ibr then return,MetroPath[ib,pt]*0 $
			else return,MetroPath[ib,pt]-MetroPath[ibr,pt]
	   end
;	   ModelDelay (sc)
	66:return,scans[pt].ModelDelay(ib)
;	   MetroDelay (sc)
	67:return,scans[pt].MetroDelay(ib)
;	   Hour angle (mt)
	68:begin
	   hadec=sidpointing(sidmodel(ib+1),motorangle[*,ib,pt],1)
	   return,hadec[0,*]
	   end
;	   Declination (mt)
	69:begin
	   hadec=sidpointing(sidmodel(ib+1),motorangle[*,ib,pt],1)
	   return,hadec[1,*]
	   end
;	   Azimuth (mt)
	70:return,motorangle[0,ib,pt] $
		+double(double(sidmodel(ib+1)),5*sizeof(double(0)))*0
;	   Elevation (mt)
	71:return,motorangle[1,ib,pt] $
		+double(double(sidmodel(ib+1)),7*sizeof(double(0)))*0
;	   Par X C (mt)
	72:begin
	   hadec=sidpointing(sidmodel(ib+1),motorangle[*,ib,pt],1)
	   mp=mirrorpivot(sidmodel(ib+1),hadec[0,*],hadec[1,*], $
		MetroConfig.SidModel.PivotOffset[*,ib])
	   return,ParX[ib,pt]-mp[*,0]
	   end
;	   Par Y C (mt)
	73:begin
	   hadec=sidpointing(sidmodel(ib+1),motorangle[*,ib,pt],1)
	   mp=mirrorpivot(sidmodel(ib+1),hadec[0,*],hadec[1,*], $
		MetroConfig.SidModel.PivotOffset[*,ib])
	   return,ParY[ib,pt]-mp[*,1]
	   end
;	   Par Z C (mt)
	74:begin
	   hadec=sidpointing(sidmodel(ib+1),motorangle[*,ib,pt],1)
	   mp=mirrorpivot(sidmodel(ib+1),hadec[0,*],hadec[1,*], $
		MetroConfig.SidModel.PivotOffset[*,ib])
	   return,ParZ[ib,pt]-mp[*,2]
	   end
;	   NATCounts (sc)	Averaged total quad cell counts
	75:return,scans[pt].NATCounts(ib)
;	   BeamCounts (sc)	The sum of all NAT counts in an output beam
	76:return,total(scans[pt].NATCounts(*)*beamconfig(ob+1,pt+1),1)
;	   SpecCounts (sc)	Total photonrate in spectrometer
	77:return,total(scans[pt].PhotonRate(ob,0:genconfig.numspecchan[ob]-1) $
	       *(signof(scans[pt].PhotonRateErr(ob,0:genconfig.numspecchan[ob]-1))>0),2
;	   Azimuth (sc)  	Azimuth of star (horizon coordinates)
	78:return,scans[pt].AZ/RAD
;	   uv-Angle (sc)	Position angle of projected baseline
	79:begin
;	   BLPA=degrees east of north
	   blpa=atan(scans[pt].UVW(ob,ch,bl,0), $
		     scans[pt].UVW(ob,ch,bl,1))*RAD
	   index=where(blpa lt 0,count)
	   if count gt 0 then blpa[index]=blpa[index]+180
	   if count gt 1 then $
	   if blpa[0] gt blpa[1] then blpa[0]=blpa[0]-180
	   return,blpa
	   end
;	   SI (sc)		Scintillation index
	80:return,scans[pt].si(ob,ch)
;	   R0 (sc) 		Fried's parameter
	81:return,scans[pt].r0
;	   T0 (sc)		Coherence time [ms]
	82:return,scans[pt].t0(ob,ch,bl)*1000
;	   PWV (sc)
	83:return,scans[pt].pwv
;	   DelayRMS (sc)	RMS of residual delay over scan
	84:return,scans[pt].delayrms(ob,bl)
;	   PhaseRMS (sc)	RMS of FINITO phase
	85:return,scans[pt].phaserms(ob,bl)
;	   DelayJitter (sc)	Short term RMS of delay
	86:return,scans[pt].delayjitter2(ob,bl)
;	   NATOffsetXRMS
	87:return,scans[pt].natjitter2(ib,0)
;	   NATOffsetYRMS
	88:return,scans[pt].natjitter2(ib,1)
;	   NATOffsetXYRMS	Geometric mean of X and Y RMS
	89:return,sqrt(scans[pt].natjitter2(ib,0)*scans[pt].natjitter2(ib,1))
;	   AngleJitter		Baseline value of NATOffsetXY
	90:begin
	   i=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],0,3))
	   j=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],4,3))
	   return,sqrt(scans[pt].natjitter2(i,0)*scans[pt].natjitter2(i,1) $
		      +scans[pt].natjitter2(j,0)*scans[pt].natjitter2(j,1))
	   end
;	   DiffPhase (sc)
	91:return,scans[pt].DiffPhase(ob,ch,bl)
;	   DiffPhaseC (sc)
	92:return,scans[pt].DiffPhaseC(ob,ch,bl)
;	   DiffPhaseM (sc)
	93:return,scans[pt].DiffPhaseM(ob,ch,bl)
;	   Photometry (sc)
	94:return,scans[pt].Photometry(ib,ob,ch);/median(scans(pt).Photometry(ib,ob,ch)
;	   PhotometryC (sc)
	95:return,scans[pt].PhotometryC(ib,ob,ch)
;	   PhotometryM (sc)
	96:return,scans[pt].PhotometryM(ib,ob,ch)
      else:begin
	   print,'***Error(SET_PLOTDATA): item not allowed:',item
	   return,-1
	   end
endcase
;
end
