function set_ploterr,item,ib,ob,tr,ch,bl,pt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given data array indices, return corresponding data errors for item.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common Tables,ScanTable,BGTable,StationTable
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common SeeingData,scintillation,r0,t0,delayrms,phaserms,delayjitter2,natjitter2
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
if item[0] eq 3 or item[0] eq 6 then begin
case SystemId of
        'Mark3'   :normfactor=pi_circle^2/2
        'NPOI'    :normfactor=4.0/sinc(float(GenConfig.FringeMod[bl,ob]) $
				       /GenConfig.NumBin)^2
              else:normfactor=1.0
endcase
endif
ibr=GenConfig.RefStation-1
;
; Intercept some common user errors
icheck=0
if long(where([6,7,28,29,30,31,32,33] eq item),0) ne -1 $
	and GenConfig.NumTriple eq 0 then icheck=1
if icheck then begin
	print,'***Error(SET_PLOTDATA): no data to plot!'
	return,-1
endif
;
case item[0] of
;	NPOI CONSTRICTOR data
	 1:return,(PointTime[pt] ge 0)*2-1
	 2:return,(PointTime[pt] ge 0)*2-1
;	 3:return,signof(VisSqErr(ob,ch,bl,pt),PhotonRateErr(ob,ch,pt)) $
;	    *normfactor $
;           *abs(VisSq(ob,ch,bl,pt)/nonzero(PhotonRate(ob,ch,pt))^2) $
;           *sqrt((VisSqErr(ob,ch,bl,pt)/nonzero(VisSq(ob,ch,bl,pt)))^2 $
;                 +4*(PhotonRateErr(ob,ch,pt)/nonzero(PhotonRate(ob,ch,pt)))^2)
	 3:return,VisSqErr[ob,ch,bl,pt]*normfactor $
		 /nonzero(PhotonRate[ob,ch,pt])^2
	 4:return,VisSqErr[ob,ch,bl,pt]
	 5:return,VisPhaseErr[ob,ch,bl,pt]*RAD
;	 6:return,TripleAmpErr(tr,ch,pt)
	 6:return,TripleAmpErr[tr,ch,pt]*normfactor^1.5 $
		 /nonzero(Photonrate[GenConfig.TripleBeam[0,tr], $
				     GenConfig.TripleChan[ch,0,tr],pt] $
		         *PhotonRate[GenConfig.TripleBeam[1,tr], $
				     GenConfig.TripleChan[ch,1,tr],pt] $
			 *PhotonRate[GenConfig.TripleBeam[2,tr], $
				     GenConfig.TripleChan[ch,2,tr],pt])
	 7:return,TriplePhaseErr[tr,ch,pt]*RAD
	 8:return,PhotonRateErr[ob,ch,pt]
	 9:return,FDLPosErr[ib,pt]
	10:return,DelayJitterErr[ob,bl,pt]*1000000
	11:return,NATJitterErr[ib,pt]
	12:return,NATCountsErr[ib,pt]
	13:return,GrpDelayErr[ib,pt]
	14:return,DryDelayErr[ib,pt]
	15:return,WetDelayErr[ib,pt]
	16:begin
	   sign=fltarr(n_elements(pt))+1
	   index=where(FDLPosErr[ib,pt] lt 0 $
		    or FDLPosErr[ibr,pt] lt 0 $
		    or DryDelayErr[ib,pt] lt 0,count)
	   if count gt 0 then sign[index]=-1
	   return,sqrt((FDLPosErr[ib,pt]*1d6)^2 $
		      +DryDelayErr[ib,pt]^2)*sign
	   end
	17:return,(abs(FDLPosErr[ib,pt]) $
	      *signof(FDLPosErr[ib,pt],FDLPosErr[ibr,pt]))*1e6
	18:begin
	   if n_elements(MetroPosErr) le 1 then return,0
	   return,MetroPosErr[ib,pt]
	   end
;	NPOI background data
	19:return,(bgscans[pt].Time ge 0)*2-1
	20:return,(bgscans[pt].Time ge 0)*2-1
	21:return,bgscans[pt].RateErr(ob,ch)
;	General "scan" (i.e., averaged) data
;	22:return,(scans(pt).Time ge 0)*2-1 ; date change issue, 27.7.2020
	22:return,(scans[pt].int_time gt 0)*2-1
;	23:return,(scans(pt).Time ge 0)*2-1 ; date change issue, 27.7.2020
	23:return,(scans[pt].int_time gt 0)*2-1
	24:return,scans[pt].VisSqErr(ob,ch,bl)
	25:return,scans[pt].VisSqCErr(ob,ch,bl)
	250:begin
	   sigma=-genconfig.wavelength[ch,ob]/4e-6*0.1+0.4
	   return,(scans[pt].VissqC(ob,ch,bl)*sigma > 0.002) $
		*signof(scans[pt].VisSqCErr(ob,ch,bl))
	   end
	26:return,scans[pt].VisSqEErr(ob,ch,bl)
	27:return,scans[pt].VisSqECErr(ob,ch,bl)
	28:return,scans[pt].TripleAmpErr(tr,ch)
	29:return,scans[pt].TripleAmpCErr(tr,ch)
	30:return,scans[pt].TripleAmpEErr(tr,ch)
	31:return,scans[pt].TripleAmpECErr(tr,ch)
	32:return,scans[pt].TriplePhaseErr(tr,ch)*RAD
	33:return,scans[pt].TriplePhaseCErr(tr,ch)*RAD
	34:return,scans[pt].PhotonRateErr(ob,ch)
	35:return,scans[pt].BackgndErr(ob,ch)
	36:return,scans[pt].FDLPosErr(ib)
	37:return,scans[pt].DelayJitterErr(ob,bl)*1000000
	38:begin
	   i=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],0,3))
	   j=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],4,3))
	   sign=fltarr(n_elements(pt))+1
	   index=where(scans[pt].NATJitterErr(i) lt 0 $
		    or scans[pt].NATJitterErr(j) lt 0,count)
	   if count gt 0 then sign[index]=-1
	   return,(sqrt(scans[pt].NATJitterErr(i)^2 $
		       +scans[pt].NATJitterErr(j)^2))*sign
	   end
	39:return,abs(scans[pt].FDLPosErr(ib)) $
	      *signof(scans[pt].FDLPosErr(ib),scans[pt].FDLPosErr(ibr))
	40:return,scans[pt].GeoDelay(ib)*0+1.e-6
	41:return,scans[pt].UVW(ob,ch,bl,0)*0
	42:return,fltarr(n_elements(pt))+1.0
	43:return,fltarr(n_elements(pt))+1.0
	44:return,fltarr(n_elements(pt))+1.0
	45:return,GenConfig.WavelengthErr[ch,ob]*1d6
	46:return,fltarr(n_elements(ch))+0.1
	47:return,fltarr(n_elements(bl))
	48:return,fltarr(n_elements(bl))
	49:return,fltarr(n_elements(tr))
	50:return,scans[pt].UVW(ob,ch,bl,0)*0
	51:return,scans[pt].UVW(ob,ch,bl,0)*0
	52:return,scans[pt].UVW(ob,ch,bl,0)*0
	53:return,abs(scans[pt].FDLPosErr(ib)*1000000) $
	      *signof(scans[pt].FDLPosErr(ib),scans[pt].FDLPosErr(ibr))
	54:return,scans[pt].GrpDelayErr(ib)*1000000
	55:return,scans[pt].DryDelayErr(ib)*1000000
	56:return,scans[pt].WetDelayErr(ib)*1000000
	57:return,fltarr(n_elements(pt))
	58:return,fltarr(n_elements(pt))
	59:return,fltarr(n_elements(pt))
	60:return,(MetroTime[pt] ge 0)*2-1
	61:return,ParXErr[ib,pt]
	62:return,ParYErr[ib,pt]
	63:return,ParZErr[ib,pt]
	64:return,MetroPathErr[ib,pt]
	65:begin
	   sign=fltarr(n_elements(pt))+1
	   index=where(MetroPathErr[ib,pt] lt 0 $
                    or MetroPathErr[ibr,pt] lt 0,count)
	   if count gt 0 then sign[index]=-1
   	   return,sqrt(MetroPathErr[ib,pt]^2+MetroPathErr[ibr,pt]^2)*sign
	   end
	66:return,scans[pt].ModelDelayErr(ib)
	67:return,scans[pt].MetroDelayErr(ib)
	68:return,(fltarr(n_elements(pt))+1)*signof(motorangleerr[0,ib,pt])
	69:return,(fltarr(n_elements(pt))+1)*signof(motorangleerr[1,ib,pt])
	70:return,motorangleerr[0,ib,pt]
	71:return,motorangleerr[1,ib,pt]
	72:return,ParXErr[ib,pt]
	73:return,ParYErr[ib,pt]
	74:return,ParZErr[ib,pt]
	75:return,scans[pt].NATCountsErr(ib)
	76:return,sqrt(total(scans[pt].NATCountsErr(*)^2*beamconfig(ob+1,pt+1),1))
	77:return,sqrt(total(scans[pt].PhotonRateErr(ob,0:genconfig.numspecchan[ob]-1)^
	            *(signof(scans[pt].PhotonRateErr(ob,0:genconfig.numspecchan[ob]-1))
	78:return,fltarr(n_elements(pt))+1.0
	79:return,scans[pt].UVW(ob,ch,bl,0)*0
	80:return,scans[pt].si(ob,ch)*0+1
	81:return,scans[pt].r0*0+0.02
	82:return,scans[pt].t0(ob,ch,bl)*0+0.05 ; [s]
	83:return,scans[pt].pwv*0+1
	84:return,scans[pt].delayrms(ob,bl)*0+1
	85:return,scans[pt].phaserms(ob,bl)*0+1
	86:return,scans[pt].delayjitter2(ob,bl)*0+1
	87:return,scans[pt].natjitter2(ib,0)*0+1
	88:return,scans[pt].natjitter2(ib,1)*0+1
	89:return,sqrt(scans[pt].natjitter2(ib,0)*scans[pt].natjitter2(ib,1))*0+1
	90:begin
	   i=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],0,3))
	   j=where(GenConfig.StationId eq $
	    strmid(GenConfig.BaselineId[bl,ob],4,3))
	   return,sqrt(scans[pt].natjitter2(i,0)*scans[pt].natjitter2(i,1) $
		      +scans[pt].natjitter2(j,0)*scans[pt].natjitter2(j,1))*0+1
	   end
	91:return,scans[pt].DiffPhaseErr(ob,ch,bl)
	92:return,scans[pt].DiffPhaseCErr(ob,ch,bl)
	93:return,fltarr(n_elements(pt))
	94:return,scans[pt].PhotometryErr(ib,ob,ch)
	95:return,scans[pt].PhotometryCErr(ib,ob,ch)
	96:return,fltarr(n_elements(pt))
      else:begin
	   print,'***Error(SET_PLOTERR): item not allowed:',item
	   return,-1
	   end
endcase
;
end
