pro set_plotlabels,plot_labels,axis_index,item
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot labels indicate the array index settings for plotted variables.
; This procedure prepares a string array containing the labels and an
; integer array indicating which labels apply to the selected axis item.
; The sliced dimension is not labeled.
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
plot_labels=sindgen(6)
plot_labels[0]=' IB'
plot_labels[1]=' OB'
plot_labels[2]=' Tr'
plot_labels[3]=' Bl'
plot_labels[4]=' Ch'
plot_labels[5]=' Pt'
axis_index=intarr(6)
;
; IB
list=[9,11,12,13,14,15,16,17,18,36,39,40,53,54,55,56,61,62,63,64,65,66,67, $
	68,69,70,71,72,73,74,75,79,87,88,89,94,95,96]
index=where(list eq item,count)
if count gt 0 and slice ne 'ib' then begin
	axis_index[0]=1
	list=[13,14,15,16,17,18,39,40,53,54,55,56,65,67]
	index=where(list eq item,count)
	if count gt 0 then plot_labels[0]=plot_labels[0] $
                          +'('+string(GenConfig.RefStation,format='(i1)')+')'
endif
;
; OB
list=[3,4,5,8,10,21,24,25,26,27,34,35,37,50,51,52,76,77,80,82,84,85,86, $
	90,91,92,93,94,95,96]
index=where(list eq item,count)
if count gt 0 and slice ne 'ob' then axis_index[1]=2
;
; Tr
list=[6,7,28,29,30,31,32,33,58,59]
index=where(list eq item,count)
if count gt 0 and slice ne 'tr' then axis_index[2]=3
;
; Ch
list=[3,4,5,6,7,8,21,24,25,26,27,28,29,30,31,32,33,34,35,50,51,52,80,82, $
	91,92,93,94,95,96]
index=where(list eq item,count)
if count gt 0 and slice ne 'ch' then axis_index[4]=5
;
; Bl
list=[3,4,5,10,24,25,26,27,37,38,41,50,51,52,82,84,85,86,90,91,92,93]
index=where(list eq item,count)
if count gt 0 and slice ne 'bl' then axis_index[3]=4
;
; Pt
list=[3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,21,24,25,26,27,28,29,30,31,32, $
	33,34,35,36,37,38,39,40,41,50,51,52,53,54,55,56,57,58,59,60,61,62,63, $
	64,66,68,69,70,71,72,73,74,75,76,77,79,80,81,82,83,84,85,86,87,88,89, $
	90,91,92,93,94,95,96]
index=where(list eq item,count)
if count gt 0 and slice ne 'pt' then axis_index[5]=6
;
index=where(axis_index ne 0)
if index[0] ne -1 then axis_index=axis_index[index]-1 else axis_index=-1
;
; For publications, do not include the labels
; if ps_options.p then axis_index=-1
;
end
