pro set_pointflagtable,reason,item,inbeam,outbeam,triple,channel,baseline,time
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Stores new entries in pointflagtable, expanding the table if necessary.
;
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
min_incr=2000
num_flag=n_elements(item)
if n_elements(pointflagtable) eq 0 then create_pointflagtable,num_flag+min_incr
num_tble=n_elements(pointflagtable)
;
index=where(pointflagtable.time gt 0,count)
if count gt 0 then id0=index[count-1]+1 else id0=0
;
if num_flag gt num_tble-id0 then begin
	table=pointflagtable
	create_pointflagtable,num_tble+num_flag+min_incr
	pointflagtable[0:num_tble-1].reason=table.reason
	pointflagtable[0:num_tble-1].item=table.item
	pointflagtable[0:num_tble-1].inbeam=table.inbeam
	pointflagtable[0:num_tble-1].outbeam=table.outbeam
	pointflagtable[0:num_tble-1].triple=table.triple
	pointflagtable[0:num_tble-1].channel=table.channel
	pointflagtable[0:num_tble-1].baseline=table.baseline
	pointflagtable[0:num_tble-1].time=table.time
endif
;
if num_flag eq 1 then begin
	pointflagtable[id0:id0+num_flag-1].reason=reason[0]
	pointflagtable[id0:id0+num_flag-1].item=item[0]
	pointflagtable[id0:id0+num_flag-1].inbeam=inbeam[0]
	pointflagtable[id0:id0+num_flag-1].outbeam=outbeam[0]
	pointflagtable[id0:id0+num_flag-1].triple=triple[0]
	pointflagtable[id0:id0+num_flag-1].channel=channel[0]
	pointflagtable[id0:id0+num_flag-1].baseline=baseline[0]
	pointflagtable[id0:id0+num_flag-1].time=time[0]
endif else begin
	pointflagtable[id0:id0+num_flag-1].reason=reason
	pointflagtable[id0:id0+num_flag-1].item=item
	pointflagtable[id0:id0+num_flag-1].inbeam=inbeam
	pointflagtable[id0:id0+num_flag-1].outbeam=outbeam
	pointflagtable[id0:id0+num_flag-1].triple=triple
	pointflagtable[id0:id0+num_flag-1].channel=channel
	pointflagtable[id0:id0+num_flag-1].baseline=baseline
	pointflagtable[id0:id0+num_flag-1].time=time
endelse
;
end
