pro set_ps,filename,color=color,landscape=landscape,page_size=page_size
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Starting with IDL 7.1, 24-bit images can be sent to a PostScript device,
; even though that has an indexed color model as a default. All you need to do
; is to make sure that a greyscale color table is loaded before calling
; TV, e.g., set_plot,'ps' & device, decomposed=0 & loadct,0 & tv, rose, /true
;
if n_elements(filename) eq 0 then filename='idl.ps'
if n_elements(landscape) eq 0 then landscape=0
if n_elements(color) eq 0 then color=0
;
a4=[21.0,29.7]
;
; Special call to change page size *after* this procedure has been called before
if n_elements(page_size) ne 0 then begin
	case page_size of
	'a3':ps=a4*sqrt(2)
	'a4':ps=a4
	'a5':ps=a4/sqrt(2)
	endcase
	if landscape then ps=ps[[1,0]]
	device,xsize=ps[0],ysize=ps[1],yoffset=0.,xoffset=0.
	return
endif
;
; cleanplot,/silent
;
set_plot,'ps'
device,filename=filename,color=color
; device,/times	; Does not work with GDL
;
if landscape then device, ysize=a4[0],xsize=a4[1],yoffset=0.,xoffset=0. $
	     else device, xsize=a4[0],ysize=a4[1],yoffset=0.,xoffset=0.
;
!p.font=3	; Hershey vector font #3 (Simplex Roman)
!p.charthick=1
!p.thick=2
!x.thick=1
!y.thick=1
;
if color then tek_color
;
end
