function set_scale,image,j
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; In pearl, tvscl is not used normally in order to avoid the rescaling effect
; when CLEANing for example. Therefore, we determine the scaling parameters
; at the beginning and store them with the images, which are then displayed
; with tv.
;
; Image can be a Pearl image or a flat map.
;
if n_elements(j) eq 0 then j=0
;
r=size(image)
if r[n_elements(r)-2] eq 8 then map=image.maps[j].map else map=image
;
maxm=max(map)
minm=min(map)
;
zero=minm
if maxm gt minm then scale=(!d.table_size-1)/(maxm-minm) $
		else scale=0
;
if r[n_elements(r)-2] eq 8 then begin
	image.zero[j]=zero
	image.scale[j]=scale
endif
;
return,[zero,scale]
;
end
