function set_starsel
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
;
flag=0
if n_elements(st_dir) eq 0 then flag=1
if flag then begin
	print,'***Error(SET_STARSEL): stars directives undefined!'
	return,-1
endif
;
; Prepare star selection
;
if st_dir eq 'All' then begin
	list_stars,ds_stars
	if class eq 'metro' then ds_stars=[ds_stars,'CCCslew']
endif else if st_dir eq 'Cal' then begin
        index=where(startable.bflag eq 'C',count)
        if count gt 0 then ds_stars=startable[index].starid $
          else begin
	    print,'***Error(SET_STARSEL): no calibrators listed in startable!'
	    return,-1
	  endelse
endif else if st_dir eq 'Sci' then begin
        index=where(startable.bflag ne 'C',count)
        if count gt 0 then ds_stars=startable[index].starid $
          else begin
	    print,'***Error(SET_STARSEL): no calibrators listed in startable!'
	    return,-1
	  endelse
endif else if st_dir eq 'Sel' then begin
	if st_sel[0] eq '' then begin
	   print,'***Error(SET_STARSEL): you have to select stars first!'
	   return,-1
	endif
	ds_stars=st_sel
endif
;
return,0
;
end
