pro set_streamsel,stream_in,item,ds_ib,ds_ob,ds_tr,ds_ch,ds_bl,ds_pt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Extracts the data selection from a stream and returns it as plain arrays.
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
;
; NoTrace option not selected (default): X-selection will trace Y-selection
if stream_in eq 'x' and not ps_options.t then stream='y' else stream=stream_in
;
case stream of
	'x':begin
	    if n_elements(ds_x) eq 0 then return
	    item=ds_x.item
	    ds_ib=ds_x.ib
	    ds_ob=ds_x.ob
	    ds_tr=ds_x.tr
	    index=where(ds_x.ch ge 0,count)
	    if count gt 0 then ds_ch=ds_x.ch[index] else ds_ch=-1
	    index=where(ds_x.bl ge 0,count)
	    if count gt 0 then ds_bl=ds_x.bl[index] else ds_bl=-1
;	    index=where(ds_x.tr ge 0,count)
;	    if count gt 0 then ds_tr=ds_x.tr(index) else ds_tr=-1
	    index=where(ds_x.pt ge 0,count)
	    if count gt 0 then ds_pt=ds_x.pt[index] else ds_pt=-1
	    end
	'y':begin
	    if n_elements(ds_y) eq 0 then return
	    item=ds_y.item
	    ds_ib=ds_y.ib
	    ds_ob=ds_y.ob
	    ds_tr=ds_y.tr
	    index=where(ds_y.ch ge 0,count)
	    if count gt 0 then ds_ch=ds_y.ch[index] else ds_ch=-1
	    index=where(ds_y.bl ge 0,count)
	    if count gt 0 then ds_bl=ds_y.bl[index] else ds_bl=-1
;	    index=where(ds_y.tr ge 0,count)
;	    if count gt 0 then ds_tr=ds_y.tr(index) else ds_tr=-1
	    index=where(ds_y.pt ge 0,count)
	    if count gt 0 then ds_pt=ds_y.pt[index] else ds_pt=-1
	    end
	'z':begin
	    if n_elements(ds_z) eq 0 then return
	    item=ds_z.item
	    ds_ib=ds_z.ib
	    ds_ob=ds_z.ob
	    ds_tr=ds_z.tr
	    index=where(ds_z.ch ge 0,count)
	    if count gt 0 then ds_ch=ds_z.ch[index] else ds_ch=-1
	    index=where(ds_z.bl ge 0,count)
	    if count gt 0 then ds_bl=ds_z.bl[index] else ds_bl=-1
;	    index=where(ds_z.tr ge 0,count)
;	    if count gt 0 then ds_tr=ds_z.tr(index) else ds_tr=-1
	    index=where(ds_z.pt ge 0,count)
	    if count gt 0 then ds_pt=ds_z.pt[index] else ds_pt=-1
	    end
endcase
;
end
