pro set_tripleampphase
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute TripleAmp and TriplePhase, as well as their respective errors, from
; the complex quantities ComplTriple and ComplTripleErr for plotting
; and editing. Phases are counter-clockwise from 1+0i in radians.
; See comments in set_visampphase for further information.
;
; Note that for simplicity, we flag all data where the triple amplitude
; is exactly zero.
;
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
;	The following code should accomplish the same what procedure
;	set_visampphase does, only in a different way.
;
	TriplePhase[*]=0
	CTR=double(ComplTriple[*,0,*,*])
	CTI=double(ComplTriple[*,1,*,*])
	CTRE=double(ComplTripleErr[*,0,*,*])
	CTIE=double(ComplTripleErr[*,1,*,*])
	CTA=sqrt(CTR^2+CTI^2)
	TripleAmp[*,*,*]=CTA
	TripleAmpErr[*,*,*]=CTRE
	TriplePhase[*,*,*]=atan(CTI,CTR)
	TriplePhaseErr[*,*,*]=atan(CTIE,CTA)
	index=where(CTA gt 0,count)
	if count gt 0 then begin
;	TripleAmpErr(index)= $
;		sqrt(((CTR(index)/CTA(index))*CTRE(index))^2 $
;		    +((CTI(index)/CTA(index))*CTIE(index))^2)
;	TriplePhase(index)=atan(CTI(index),CTR(index))
;	TriplePhaseErr(index)=TripleAmpErr(index)/TripleAmp(index)
	endif else print,'Warning(SET_TRIPLEAMPPHASE): no valid data!'
	index=where(CTRE le 0 or CTIE le 0,count)
	if count gt 0 then begin
		TripleAmpErr[index]=-1
		TriplePhaseErr[index]=-1
	endif
;
;	This command effectively flags input data where the derived
;	amplitude is zero.
        index=where(TripleAmp eq 0,count)
	if count gt 0 then begin
		CTRE[index]=-1
		CTIE[index]=-1
		ComplTripleErr[*,0,*,*]=CTRE
		ComplTripleErr[*,1,*,*]=CTIE
	endif
;
end
