pro set_triplephase
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute scans.triplephasec from complex visibility for all scans.
; A part of this code (inner FOR loop) is used in set_complexvis.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
phase=cphase(scans.complexvis)
nc=max(genconfig.numspecchan)
ns=n_elements(scans)
;
g=genconfig
;
for i=0,genconfig.numtriple-1 do begin
;
fBaseMatrix=intarr(GenConfig.NumSid,3)
fBaseFactor=fltarr(3)+1
for l=0,2 do begin
	ob=GenConfig.TripleBeam[l,i]
	bl=GenConfig.TripleBase[l,i]
	j1=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[bl,ob],0,3))
	j2=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[bl,ob],4,3))
	fBaseMatrix[j1,l]=+1
	fBaseMatrix[j2,l]=-1
	if l gt 0 then fBaseFactor[l]= $
		(-total(fBaseMatrix[*,0]*fBaseMatrix[*,l]) gt 0)*2-1.0
endfor
scans.triplephasec[i,*]=reform $
       (fBaseFactor[0]*phase[g.triplebeam[0,i],*,g.triplebase[0,i],*] $
       +fBaseFactor[1]*phase[g.triplebeam[1,i],*,g.triplebase[1,i],*] $
       +fBaseFactor[2]*phase[g.triplebeam[2,i],*,g.triplebase[2,i],*],1,nc,ns)
;
endfor
;
end
