function set_uvc,imsze,cellsze,nc,relax=relax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return a uv-coverage of dimension imsize(0)*imsize(1), i.e. column by row,
; width by height, and cellsize in Mlambda.
;
; Both dimensions must be odd numbers, so that there will be a pixel on the
; center of the image. The bottom left corner is at pixel (0,0), the top right
; corner is (imsize(0)-1,imsize(1)-1)
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
MAS2RAD=pi_circle/(180l*3600000l)
;
if n_elements(relax) eq 0 then relax=0
;
if not relax then begin
if imsze[0] mod 2 ne 1 then begin
        print,'***Error(SET_UVC): imsize[0] must be odd number!'
        return,-1
endif
if imsze[1] mod 2 ne 1 then begin
        print,'***Error(SET_UVC): imsize[1] must be odd number!'
        return,-1
endif
endif
if n_elements(nc) eq 0 then nc=1
;
imsize=long(imsze)
cellsize=float(cellsze)
;
map=complexarr(imsize[0],imsize[1],nc)
u=(lindgen(imsize[0]*imsize[1]) mod imsize[0]) - (imsize[0]/2)
v=(lindgen(imsize[0]*imsize[1]) / imsize[0]) - (imsize[1]/2)
u=-u*cellsize
v=+v*cellsize
;
return,{map:map,u:u,v:v}
;
end
