pro setmodel,star
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Using the local orbital elements, initialize a binary model.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common StarBase,StarTable,Notes
;
RAD=180/pi_circle
;
if n_elements(binary_model) eq 0 then begin
	print,'***Warning(SETMODEL): initializing model...'
;
	wavelengths=[0.550d0,0.700d0,0.850d0]
	num_wave=n_elements(wavelengths)
	gen_model=alloc_gen_model(num_wave)
	gen_model.starid='CCCNNNN'
	gen_model.wavelengths=wavelengths
	gen_error=gen_model
;
	numspot=2
	star_struct=alloc_star_struct(num_wave,numspot)
	star_model=replicate(star_struct,2)
	star_model[0].component='A'
	star_model[1].component='B'
	star_model[*].mass=1
	star_error=star_model
;
	binary_struct=alloc_binary_struct()
	binary_model=replicate(binary_struct,1)
	binary_model[0].component='A-B'
	binary_model[0].method=1
	binary_error=binary_model
;
endif
;
if n_elements(star) ne 0 then begin
	index=where(StarTable.starid eq star,count)
	if count eq 0 then return
	gen_model.starid=star
	gen_model.ra=startable[index].ra
	gen_model.dec=startable[index].dec
	star_model.mass=1
        binary_model.semimajoraxis=startable[index].a
        binary_model.inclination=startable[index].i
        binary_model.ascendingnode=startable[index].n
        binary_model.eccentricity=startable[index].e
        binary_model.periastron=startable[index].o
        binary_model.apsidalmotion=0
        binary_model.epoch=startable[index].t-2440000L
        binary_model.period=startable[index].p
	return
;
endif
;
index=where(binary_model.component eq orbit_options.component,count)
if count eq 0 then begin
	print,'***Error(SETMODEL): component not found in binary_model!'
	return
endif
binary_model[index].semimajoraxis	=o_parms[0]
binary_model[index].eccentricity	=o_parms[1]
binary_model[index].inclination		=o_parms[2]*RAD
binary_model[index].periastron		=o_parms[3]*RAD
binary_model[index].ascendingnode	=o_parms[4]*RAD
binary_model[index].period		=o_parms[5]
binary_model[index].epoch		=o_parms[6]
;
if not !quiet then print,'Model set.'
;
end
