pro setorbit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize local orbital parameters using the loaded binary model.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(binary_model) eq 0 then begin
	print,'***Error(SETORBIT): no binary_model loaded!'
	return
endif
;
index=where(binary_model.component eq orbit_options.component,count)
if count eq 0 then begin
	print,'***Error(SETORBIT): component not found in binary_model!'
	return
endif
o_parms=dblarr(8)
o_parms[0]=binary_model[index].semimajoraxis
o_parms[1]=binary_model[index].eccentricity
o_parms[2]=binary_model[index].inclination/RAD
o_parms[3]=binary_model[index].periastron/RAD
o_parms[4]=binary_model[index].ascendingnode/RAD
o_parms[5]=binary_model[index].period
o_parms[6]=binary_model[index].epoch
;
if not !quiet then print,'Orbit set.'
;
end
