function setrocheparms,model,lamda,u,v
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return array of parameters needed by the Roche code to compute model.
; This function is for the code V-1.4
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
common AuxData,parallaxes,k1,k2,vsini
;
RAD=180/pi_circle
;
rocheparms=fltarr(7)
;
rocheparms[0]=model.omega	; Rotational velocity ( < 1) in units of
				; break-up velocity
rocheparms[1]=((model.diameter/2)/parallaxes.value[0])*(a_unit/r_sun)
				; Stellar radius [Rsun] for zero rotation
rocheparms[2]=model.teff	; Effective temperature at pole for omega=1
rocheparms[3]=model.mass	; Stellar mass, needed to compute gravity
rocheparms[4]=model.tilt/RAD	; tilt of the rotation axis to LOS in degrees
				; Positive tilt moves pole southwards
rocheparms[5]=model.pa		; Pos. angle of the rotation  axis on sky,
				; from N over E
rocheparms[6]=model.diameter	; Polar angular diameter at breakup,
				; which is 0.8913 of the diameter of the
				; non-rotating star. But acc. to more recent
				; theories, is almost (1-2%) the same, so
				; we just use the angular diameter.
;
return,rocheparms
;
end
