function setrocheparms13,model,lamda,u,v
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return array of parameters needed by the Roche code to compute model.
; This function is for the code V-1.3
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
common AuxData,parallaxes,k1,k2,vsini
;
RAD=180/pi_circle
;
rocheparms=fltarr(9)
;
rocheparms[0]=model.omega	; rotational velocity ( < 1)
				; in units of break-up vel.
rocheparms[1]=lamda*1e9	; wavelength in nm
rocheparms[2]=model.tilt	; tilt of the rotation axis to LOS in degrees
				; Positive tilt moves pole southwards
if model.tilt gt 90 then rocheparms[2]=-(180-model.tilt)
rocheparms[3]=atan(u,v)*180/!pi+model.pa
rocheparms[3]=atan(u,v)*180/!pi-model.pa
				; angle of baseline to rotational axis
rocheparms[4]=model.mass	; stellar mass
rocheparms[5]=((model.diameter/2)/parallaxes.value[0])*(a_unit/r_sun)
;				; stellar radius in units of solar radius
rocheparms[6]=model.teff	; effective temperature
rocheparms[7]=model.diameter	; Angular diameter
rocheparms[8]=model.pa	 	; PA of the maj. axis, from N over E
;
return,rocheparms
;
end
