pro setup_oyster,dir_oyster,dir_catalogs,dir_atmospheres,notv=notv,gdl=gdl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure is called by the OYSTER startup script oyster.pro
; in the OYSTER home directory. The startup script passes as arguments
; the home directories for OYSTER, the catalogs, and atmospheres, e.g.
; '/home/cah/oyster/', '/home/cah/catalogs/', and '/home/cah/atmospheres'.
;
; Run this procedure before using OYSTER data reduction scripts.
; Initializes all variables in the following common blocks.
; Also calls C-library to store path of catalogs.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
common NPOI,npoi_cat,npoi_hip
common ModelFit,parameters,ds_options
;
if n_elements(notv) eq 0 then notv=0 else notv=notv gt 0
if n_elements(gdl) eq 0 then gdl=0 else gdl=gdl gt 0
;
; Initialize user defined system variables
defsysv,'!oyster_dir',''
defsysv,'!catalogs_dir',''
defsysv,'!atmospheres_dir',''
defsysv,'!evolution_dir',''
defsysv,'!external_lib',''
defsysv,'!xsize',640
defsysv,'!ysize',512
defsysv,'!dxsize',0
defsysv,'!dysize',0
defsysv,'!qiet',0		; Do display informational messages
defsysv,'!display',!d.name
defsysv,'!v2bias',1
defsysv,'!tabias',1
defsysv,'!date_change',0	; 1 if obs. started before UT=0 (OIFITS only)
defsysv,'!offsetcal',0
defsysv,'!int_time',0		; Max. int. time [s] "w/out smearing", 0 = none
defsysv,'!idl',0		; IDL or GDL
defsysv,'!cop','COL'		; Center of phase: default is center of light
				; COP: brightest component, COM: c.o. mass
defsysv,'!owner','chummel'
;
; Initialize OYSTER home directory
;
!oyster_dir=dir_oyster
;
; Initialize catalogs home directory
;
!catalogs_dir=dir_catalogs
;
; Initialize atmospheres home directory
;
!atmospheres_dir=dir_atmospheres
;
; Add oyster source code directories to path
;
if gdl then !idl=0 else !idl=1
if gdl then $
!path=!path+':' $
     +!oyster_dir+'source/gdl:' $
     +!oyster_dir+'source/idl/lib:' $
     +!oyster_dir+'source/idl/cw_lib:' $
     +!oyster_dir+'source/cmsvlib:' $
     +!oyster_dir+'source/vinci:' $
     +!oyster_dir+'source/midi:' $
     +!oyster_dir+'source/amber:' $
     +!oyster_dir+'source/pionier:' $
     +!oyster_dir+'source/gravity:' $
     +!oyster_dir+'source/matisse:' $
     +!oyster_dir+'source/oifits:' $
     +!oyster_dir+'source/mpfit:' $
     +!oyster_dir+'source/pds:' $
     +!oyster_dir+'source/idlastro/pro:' $
     +!oyster_dir+'source/idlastro/pro/coyote:' $
     +!oyster_dir+'source/idlastro/pro/jhuapl:' $
     +!oyster_dir+'source/torun/cw_lib:' $
     +!oyster_dir+'source/torun/gdl:' $
else $
!path=!path+':' $
     +!oyster_dir+'source/idl:' $
     +!oyster_dir+'source/common:' $
     +!oyster_dir+'source/vinci:' $
     +!oyster_dir+'source/midi:' $
     +!oyster_dir+'source/amber:' $
     +!oyster_dir+'source/pionier:' $
     +!oyster_dir+'source/gravity:' $
     +!oyster_dir+'source/matisse:' $
     +!oyster_dir+'source/oifits:' $
     +!oyster_dir+'source/mpfit:' $
     +!oyster_dir+'source/pds:' $
     +!oyster_dir+'source/idlastro/pro:' $
     +!oyster_dir+'source/idlastro/pro/coyote:' $
     +!oyster_dir+'source/idlastro/pro/jhuapl:' $
     +!oyster_dir+'source/proprietary/coyote:' $
     +!oyster_dir+'source/proprietary/amores:' $
     +!oyster_dir+'source/proprietary/ttsre:' $
     +!oyster_dir+'source/proprietary/christian:' $
     +!oyster_dir+'source/proprietary/oliver:' $
     +!oyster_dir+'source/proprietary/oliver/erfa:' $
     +!oyster_dir+'source/proprietary/oliver/math:' $
     +!oyster_dir+'source/proprietary/drimmel:' $
     +!oyster_dir+'source/proprietary/drimmel/cgis:' $
     +!oyster_dir+'source/proprietary/drimmel/cgis/quidl:' $
     +!oyster_dir+'source/proprietary/hochunk3d:' $
     +!oyster_dir+'source/proprietary/tellrem/routines:'
;    +'/data/naco/NACO_SAM_pipeline/starfinder:' $
;    +'/data/naco/NACO_SAM_pipeline/code:'
;
; Initialize external library
!external_lib=''
ostype=strupcase(!version.os)
if strpos(ostype,'LINUX') ne -1 then !external_lib='linux/oyster.so'
if strpos(ostype,'DARWIN') ne -1 then !external_lib='darwin/oyster.so'
if strlen(!external_lib) eq 0 then begin
	print,'Warning(SETUP_OYSTER): possibly incompatible OS ',ostype,'!'
	!external_lib='oyster.so'
endif
!external_lib=!oyster_dir+!external_lib
r=file_search(!external_lib)
if strlen(r[0]) ne 0 then $
	status=linknload(!external_lib,'init_oyster', $
		!catalogs_dir,!atmospheres_dir, $
		pathname(!external_lib))
;
; Initialize mathematical and physical constants
;
c_light=2.997925d8			; Speed of light [m/s]
pi_circle=3.14159265358979323846d0	; PI
e_euler=2.718281828459045d0		; Euler's e
i_complex=sqrt(complex(-1))		; i
m_sun=1.9891d30                         ; kg
r_sun=6.9599d8				; m
a_unit=1.49597870d11                    ; AU [m]
s_year=365.2564d0                       ; Sidereal year [d]
;
; Initialize dispersion constants
; 			; K.P. Birch & M.J. Downs, 1993, Metrologia, 30, 155
; a_disp=dblarr(5)	; n(lambda)-1=(P/96095.43*(1+1e-8*(0.601-0.00972t)*P)/
; a_disp(0)=8343.05d0	;                        (1+0.003661t)*a(lambda)
; a_disp(1)=2406294.d0	;             -f*b(lambda)*1e-2)*1e-8
; a_disp(2)=130.d0	; a(lambda)=a0+a1/(a2-s^2)+a3/(a4-s^2)
; a_disp(3)=15999.d0	; b(lambda)=b0+b1*s^2
; a_disp(4)=38.9d0	; s=1/lambda (lambda in 1e-6 m)
; b_disp=dblarr(2)	; P=pressure in Pa
; b_disp(0)=3.7345d0	; t=t90=temperature in C
; b_disp(1)=-0.0401d0	; f=partial water vapor pressure in Pa
;
a_disp=dblarr(5)	; J.C. Owens, Appl. Opt. 6, 51 (1967)
a_disp[0]=2372.434	; n(lambda)-1=a(lambda)P/T-b(lambda)e/T
a_disp[1]=684255.24	;
a_disp[2]=130.0	;
a_disp[3]=4549.4	; a(lambda)=1e-8*(a0+a1/(a2-s2)+a3/(a4-s2))
a_disp[4]=38.9		; b(lambda)=a(lambda)-1e-8*(b0+b1*s2+b2*s4+b3*s6)
b_disp=dblarr(4)	; with a0=a_disp(0) asf. & b0=b_disp(0) asf.
b_disp[0]=6487.31	; & s2=(1/lambda)^2 asf. (lambda in 1e-6 m)
b_disp[1]=58.058	; P=pressure in mb
b_disp[2]=-0.71150	; T=temperature in K
b_disp[3]=0.08851	; e=partial water vapor pressure in mb
;
;
; Initialize Mark3 common block variables
; Note: FK5 1817 (unknown) and 2001 (Nova Cygni) are still missing!
; FKV2001 is Nova Cygni=V1974 Cyg (USR0006)
;
mark3_baselines=['NAS-SAS','NAS-EAS','NVA-SVA','NVA-SVB','NVB-SVA', $
	'NVB-SVB','NVC-SVA','NVA-SVC','NVC-SVB','NVB-SVC','NVD-SVA','NVC-SVC', $
	'NVA-SVD','NVD-SVB','NVE-SVA','NVB-SVD','NVE-SVB','NVD-SVC','NVF-SVA', $
	'NVC-SVD','NVA-SVE','NVF-SVB','NVE-SVC','NVB-SVE','NVD-SVD','NVC-SVE', $
	'NVA-SVF','NVF-SVC','NVE-SVD','NVB-SVF','NVD-SVE','NVC-SVF','NVF-SVD', $
	'NVE-SVE','NVD-SVF','NVF-SVE','NVE-SVF','NVF-SVF']
mark3_configs=['AQB','HA1','HA2','700','TIO','45A','45B', $
	     '45C','45D','STD','HA2','ST2','HA4']
mark3_cat=['FKV1700','FKV1701','FKV1702','FKV1703','FKV1704','FKV1706', $
           'FKV1707','FKV1708','FKV1709','FKV1710','FKV1711','FKV1713', $
           'FKV1714','FKV1715','FKV1716','FKV1717','FKV1718','FKV1719', $
           'FKV1720','FKV1721','FKV1722','FKV1723','FKV1724','FKV1725', $
           'FKV1726','FKV1727','FKV1728','FKV1729','FKV1730','FKV1731', $
           'FKV1732','FKV1733','FKV1734','FKV1735','FKV1736','FKV1737', $
           'FKV1738','FKV1739','FKV1740','FKV1741','FKV1742','FKV1743', $
           'FKV1744','FKV1745','FKV1746','FKV1747','FKV1748','FKV1749']
mark3_cat=[mark3_cat, $
	  ['FKV1750','FKV1751','FKV1752','FKV1753','FKV1754','FKV1755', $
           'FKV1756','FKV1757','FKV1758','FKV1759','FKV1760','FKV1761', $
           'FKV1762','FKV1763','FKV1764','FKV1765','FKV1766','FKV1767', $
           'FKV1768','FKV1769','FKV1770','FKV1771','FKV1772','FKV1773', $
           'FKV1774','FKV1775','FKV1776','FKV1777','FKV1778','FKV1779', $
           'FKV1781','FKV1782','FKV1783','FKV1784','FKV1785','FKV1786', $
           'FKV1788','FKV1789','FKV1790','FKV1791','FKV1792','FKV1793', $
           'FKV1794','FKV1795','FKV1796','FKV1797','FKV1798','FKV1799']]
mark3_cat=[mark3_cat, $
	  ['FKV1787','FKV1804','FKV1805','FKV1806','FKV1807','FKV1808', $
	   'FKV1809','FKV1810','FKV1811','FKV1812','FKV1813','FKV1814', $
	   'FKV1815','FKV1816','FKV2001']]
mark3_bsc=['BSC0271','BSC0430','BSC0244','BSC1706','BSC3773','BSC2405', $
           'BSC7564','BSC6212','BSC7806','BSC6406','BSC7478','BSC2854', $
           'BSC7528','BSC6132','BSC4057','BSC9004','BSC6752','BSC7882', $
           'BSC1766','BSC8316','BSC0681','BSC0808','BSC0804','BSC0941', $
           'BSC0618','BSC7139','BSC7751','BSC1003','BSC0843','BSC0643', $
           'BSC0219','BSC8130','BSC8752','BSC0994','BSC1601','BSC8796', $
           'BSC1412','BSC1788','BSC1948','BSC2216','BSC2095','BSC2091', $
           'BSC7897','BSC1149','BSC1156','BSC1145','BSC1180','BSC6884']
mark3_bsc=[mark3_bsc, $
          ['BSC3974','BSC5062','BSC3690','BSC5826','BSC3799','BSC4300', $
           'BSC4375','BSC4399','BSC6315','BSC3624','BSC1155','BSC6146', $
           'BSC5080','BSC3882','BSC1637','BSC1726','BSC1879','BSC3482', $
           'BSC5723','BSC7133','BSC5868','BSC4825','BSC4775','BSC8579', $
           'BSC8819','BSC8417','BSC8383','BSC7333','BSC7447','BSC7884', $
           'BSC8315','BSC0660','BSC6153','BSC0788','BSC5958','BSC8123', $
           'BSC1392','BSC7963','BSC6388','BSC1306','BSC0548','BSC1473', $
           'BSC2973','BSC1698','BSC1458','BSC1129','BSC1324','BSC1937']]
mark3_bsc=[mark3_bsc, $
	  ['BSC8865','BSC1087','BSC4248','BSC4362','BSC1496','BSC2508', $
	   'BSC2580','BSC2742','BSC2764','BSC2766','BSC8726','BSC8850', $
	   'BSC8860','BSC5329','USR0006']]
;
; Initialize NPOI common block variables
; HD200077, Gam Ari, UX Ari, AX Mon, 41 Leo, Nova Del, Alpha Comae
npoi_cat=['BSC9111',  'BSC9112',  'BSC9113',  'BSC9114',  'BSC9115', $
	  'BSC9116', 'BSC9117']
npoi_hip=['HIP103641','HIP008832','HIP016042','HIP031019','HIP050583', $
	  'USR0007', 'BSC4968']
;
; Initialize data pointer
;
ds_options=alloc_ds_options()
;
; Change prompt
;
!prompt='OYSTER> '
;
; Enable startup without X-server
if not notv then begin
; 	OYSTER now assumed to run on 24 bit or higher displays
;	window,0 & wdelete
	if not gdl then begin
		trucolor
		device,retain=2	; Refresh window when they are uncovered
	endif
;
;	Merge the resources file with the .Xdefaults resources
	if getenv('USER') eq !owner $
        	then spawn,'xrdb -merge '+!oyster_dir+'resources.owner',r $
        	else spawn,'xrdb -merge '+!oyster_dir+'resources',r
endif
; compile_opt idl2
;
print,''
print,'---------------------'
print,' OYSTER Version 9.14'
print,' by Christian Hummel'
print,'---------------------'
print,''
;
end
