function setwdparms,model,jd,lamda,spotparms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize parameters for the Wilson-Devinney code (WD, 1992).
; jd is the Julian day epochs (-2440000); lamda [m] the wavelength.
; Return the parameters in form of an array, also return spotparms.
;
; Primary: increasing spot longitude rotates star against orbital sense
;		longitude zero spot faces secondary
; Secondary: increasing longitude rotates star against orbital sense
;		longitude zero spot faces primary
; Spot latitude increases from North to South.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
common AuxData,parallaxes,k1,k2,vsini
;
RAD=180/pi_circle
;
if componentparse(model.component,comp_1,comp_2) ne 0 then return,-1
star1=where(star_model.component eq comp_1) & star1=star1[0]
star2=where(star_model.component eq comp_2) & star2=star2[0]
model1=star_model[star1]
model2=star_model[star2]
;
num_parms=54
wdparms=fltarr(num_parms)
max_spots=2
max_stars=2
spotparms=fltarr(4,max_spots,max_stars)
;
; spotparms(0,0,0)=180. 	; Latitude [deg], 0 - 180
; spotparms(1,0,0)=0.		; Longitude [deg], 0 - 360
; spotparms(2,0,0)=20.		; Radius [deg]
; spotparms(3,0,0)=0.8		; Temperature factor
;
;
ifrad=0			; controls output format (unused)
nref=1			; number of reflections if mref=2
mref=1			; simple treatment of reflection effect
ifsmv1=0 		; star spot control #1 (0/1, 0=stationary spot)
ifsmv2=0 		; star spot control #2 (0/1, 1=spot moves in long.)
icor1=1			; unknown at present
icor2=1			; unknown at present
ld=1			; linear cosine law for limb darkening
modeb=model.wdtype 	; -1: X-ray binaries
			; 0: no constraints
			; 2: detached binary
			; 3: overcontact binaries
			; 4: semi-detached binaries
			; 5: Algol-types
			; 6: double-contact
ipb=1  			; 0: compute L2 from T2; 1: decouple L from T
ifat1=0 		; 0 = Blackbody radiation, 1 = stellar atmosphere
ifat2=0 		; see ifat1
n1=10 			; number of latitude rows per hemisphere
n2=10 			; see n1, longitude elements scale with sine of latitude
bperiod=model.period	; orbital period in days
the=0. 			; semi-duration of primary eclipse (unused)
vunit=1 		; unit for radial velocity input and output (km/s)
e=model.eccentricity	; eccentricity
per=model.periastron 	; in degrees
; 			K1, K2 [km/s]
k1_m=2*pi_circle*sin(model.inclination/RAD)/sqrt(1-model.eccentricity^2) $
    *(model.period/s_year)^(-1.0/3.0) $
    *model2.mass*(model1.mass+model2.mass)^(-2.0/3.0) $
    *a_unit/s_year/86400/1000
k2_m=k1_m*(model1.mass/model2.mass)
a1sini=13751.0*sqrt(1.d0-model.eccentricity^2)*k1_m*model.period
a2sini=13751.0*sqrt(1.d0-model.eccentricity^2)*k2_m*model.period
rsun=6.96e5 		; radius of sun [km]
asemima=(a1sini+a2sini)/sin(model.inclination/RAD)/rsun
f1=model1.omega 	; ratio of axial rotation rate to orbital rate
f2=model2.omega
vga=gen_model.rv/vunit	; systemic velocity (in units of vunit)
pshift=0. 		; constant phase shift
xincl=model.inclination	; orbital inclination in degrees
xincl=(90-xincl)+90	; Bug in WD?: prograde and retrograde exchanged!
gr1=model1.gr 		; exponent in gravity darkening law
gr2=model2.gr 		; see gr1, convective envelopes: 0.3, radiative: 1.0
tavh=abs(model1.teff)/10000 	; effective temperature in 10000 K
tavc=abs(model2.teff)/10000	; see tavh, make sure tavh/tavc are positive
alb1=model1.albedo	; bolometric albedo
alb2=model2.albedo	; see alb1, convective envelopes: 0.5-1.0, radiative:1.0
poth=model.semimajoraxis/(model1.diameter/2)
			; omega potential = semi-major axis / radius
potc=model.semimajoraxis/(model2.diameter/2)
			; see poth, for second star
rm=model2.mass/model1.mass
			; mass ratio
xbol1=0.4       	; coefficient in bolometric limb darkening law
xbol2=0.4		; see xbol1
ybol1=0.0		; coefficient for logarithmic term
ybol2=0.0		; see ybol1
wl=lamda*1e6		; wavelength in microns
; model1.teff=abs(model1.teff)	; make sure stellarfluxes uses blackbody
; model2.teff=abs(model2.teff)	; make sure stellarfluxes uses blackbody
; hlum=poly(lamda*1e6,model1.flux_fitcoeffs)*4*pi_circle
hlum=stellarfluxes(model1,lamda,xh)
			; monochromatic luminosity
; clum=poly(lamda*1e6,model2.flux_fitcoeffs)*4*pi_circle
clum=stellarfluxes(model2,lamda,xc)
; we need clum/hlum=0.12
; clum=hlum*0.15
			; see hlum
tlum=hlum+clum
hlum=hlum/tlum
clum=clum/tlum
; xh=poly(lamda*1e6,model1.ld_fitcoeffs)
			; limb-darkening coefficient
; xc=poly(lamda*1e6,model2.ld_fitcoeffs)
			; see xh, for second star
yh=0.0			; see xh coefficient for logarithmic term
yc=0.0			; see yh, (unused if ld=1)
el3=0.0			; third light (unused)
zero=0.0 		; zero point for output magnitudes
factor=1.0		; scaling factor for normalized light column
phperi=wilson_wd(0)
phn=(jd-model.epoch)/bperiod mod 1	; phases of binary
if e eq 0 then phn=phn+(per-90.)/360. else phn=phn+phperi
phstrt=phn 		; start phase
phstop=phn 		; stop phase (do only phase phn)
phin=0.01  		; phase increment (we do only phn, however)
;
; spotparms(0,0,0)=180. 	; Latitude [deg], 0 - 180
; spotparms(1,0,0)=0.		; Longitude [deg], 0 - 360
; spotparms(2,0,0)=20.		; Radius [deg]
; spotparms(3,0,0)=0.8		; Temperature factor
;
spotparms=star_model.spotparms
nsp1=fix(total(total(abs(model1.spotparms),1) gt 0)); Number of spots on star 1
nsp2=fix(total(total(abs(model2.spotparms),1) gt 0)); Number of spots on star 2
;
wdparms[0] = ifrad
wdparms[1] = nref
wdparms[2] = mref
wdparms[3] = ifsmv1
wdparms[4] = ifsmv2
wdparms[5] = icor1
wdparms[6] = icor2
wdparms[7] = ld
wdparms[8] = MODEB
wdparms[9] = IPB
wdparms[10]= IFAT1
wdparms[11]= IFAT2
wdparms[12]= N1
wdparms[13]= N2
wdparms[14]= BPERIOD
wdparms[15]= THE
wdparms[16]= VUNIT
wdparms[17]= PHN
wdparms[18]= PHSTRT
wdparms[19]= PHSTOP
wdparms[20]= PHIN
wdparms[21]= E
wdparms[22]= PER
wdparms[23]= ASEMIMA
wdparms[24]= F1
wdparms[25]= F2
wdparms[26]= VGA
wdparms[27]= PSHIFT
wdparms[28]= XINCL
wdparms[29]= GR1
wdparms[30]= GR2
wdparms[31]= tavh
wdparms[32]= tavc
wdparms[33]= alb1
wdparms[34]= alb2
wdparms[35]= poth
wdparms[36]= potc
wdparms[37]= rm
wdparms[38]= xbol1
wdparms[39]= xbol2
wdparms[40]= ybol1
wdparms[41]= ybol2
wdparms[42]= WL
wdparms[43]= hlum
wdparms[44]= clum
wdparms[45]= xh
wdparms[46]= xc
wdparms[47]= yh
wdparms[48]= yc
wdparms[49]= EL3
wdparms[50]= ZERO
wdparms[51]= FACTOR
wdparms[52]= NSP1
wdparms[53]= NSP2
;
return,wdparms
;
end
