function sidlimits,ha,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return an index array for whether (1) or not (0) a given array of (ha,dec)
; is within a specified siderostat's limits.
;
; The first set of limits was empirically determined from all data until 2000.
; The other sets were provided by B. O'Neill 2003-05-01. The index
; is the unique siderostat ID, not the StationID!.
;
; The model parameters:
; [feed az, feed el, sid az, sid el, axis off, zero az, mirror off, zero el]
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(ha) ne n_elements(dec) then begin
	print,'***Error(SIDLIMITS): ha and dec have different length!'
	return,-1
endif
num_elements=n_elements(ha)
if num_elements eq 0 then begin
	print,'***Error(SIDLIMITS): ha and dec undefined!'
	return,-1
endif
;
ret_index=intarr(num_elements)+1
;
for i=0,genconfig.numsid-1 do begin
case genconfig.siderostatid[i] of
	1:	begin
	  	model=[85.322,18.227,256.787,90.314,0.,102.187,0.,49.242]
;		Centered feed
		model=[86.578, 20.073, 80.888000, 89.736, 0.00, 278.095001, 0.00, 49.201]
;		Imaging feed
		model=[84.439, 20.096, 259.895, 90.258, 0.000,  99.084, 0.00, 49.185]
	  	limits=[-43.3,+37.4,-20.4,+34.6]
	  	limits=[-39.0,+41.5,-26.2,+34.8]
	  	limits=[-41.4,+40.7,-33.4,+27.0]
	  	end
	2:	begin
	  	model=[84.861,18.971,269.189,90.223,0.,89.242,0.,49.996]
;		Centered feed
		model=[86.230, 20.389, 84.887001, 89.785, 0.00, 273.606995, 0.00, 50.013]
;		Imaging feed
		model=[84.174, 20.271,  90.081, 89.768, 0.000, 268.411, 0.00, 50.002]
	  	limits=[-43.6,+37.5,-19.4,+35.8]
	  	limits=[-39.8,+42.8,-27.2,+36.1]
	  	limits=[-42.8,+39.9,-36.2,+27.2]
	  	end
	3:	begin
	  	model=[85.493,18.761,87.168,89.793,0.,270.862,0.,50.173]
;		Centered feed
		model=[86.790, 20.148, 88.589996, 89.790, 0.00, 269.424988, 0.00, 50.214]
;		Imaging feed
		model=[84.553, 20.287, 268.742, 90.208, 0.000, 449.274, 0.00, 50.224]
	  	limits=[-42.3,+38.5,-19.3,+35.7]
	  	limits=[-41.9,+40.9,-26.9,+36.1]
	  	limits=[-40.8,+42.0,-36.1,+27.0]
	  	end
	4:	begin
;		Centered feed
		model=[86.814, 20.230, 99.125999, 89.773, 0.00, 260.230988, 0.00, 49.981]
;		Imaging feed
		model=[84.553, 20.446,  94.720, 89.812, 0.000, 264.651, 0.00, 49.918]
		limits=[-43.5,+46.5,-33.3,+26.3]
		end
	5:	begin
;		Imaging feed
		model=[84.404, 22.114,  57.258, 89.727, 0.000, -59.838, 0.00, 70.016]
		limits=[-88.6,+85.6,-69.2,+18.4]
		end
	6:	begin
;		Imaging feed
		model=[84.592, 20.446,  58.695, 89.781, 0.000, -61.789, 0.00, 64.096]
		limits=[-91.2,+91.1,-61.6,+18.2]
		end
	 else:	begin
;		Imaging feed
	      	model=[85.322,18.227,256.787,90.314,0.,102.187,0.,49.242]
	      	limits=[-43.3,+37.4,-20.4,+34.6]
	      	limits=[-39.0,+41.5,-26.2,+34.8]
	      	end
endcase
model=double(model)
;
y=sidpointing(model,natural(ha,dec),-1)
az=y[0,*]
el=y[1,*]
;
index=where((az gt limits[0]) and (az lt limits[1]) $
	and (el gt limits[2]) and (el lt limits[3]),count)
;
sid_index=intarr(num_elements)
if count gt 0 then sid_index[index]=1
for j=0,count-2 do begin
	if index[j+1]-index[j] ne 1 then begin
		if j gt count/2 then sid_index[index[j+1]:num_elements-1]=0 $
			        else sid_index[0:index[j]]=0
	endif
endfor
;
ret_index=ret_index*sid_index
endfor
;
return,ret_index
;
end
