function sidmodel,sid,model
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return, in this order, the siderostat model parameters:
; Feed beam azimuth and elevation, siderostat azimuth and elevation,
; error in angle between axes (0=>orthogonal), zero point azimuth axis,
; tilt of mirror in its cell (0=>perpendicular) zero point elevation axis,
;
; If model is defined, store this in the metro configuration.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
i=sid-1
if n_elements(model) eq 0 then $
	return,[metroconfig.sidmodel.feedbeamang[0,i], $
		metroconfig.sidmodel.feedbeamang[1,i], $
		metroconfig.sidmodel.sidang[0,i], $
		metroconfig.sidmodel.sidang[1,i], $
		metroconfig.sidmodel.axisoffang[i], $
		metroconfig.sidmodel.zeroang[0,i], $
		metroconfig.sidmodel.mirroroffang[i], $
		metroconfig.sidmodel.zeroang[1,i]]
;
metroconfig.sidmodel.feedbeamang[0,i]=model[0]
metroconfig.sidmodel.feedbeamang[1,i]=model[1]
metroconfig.sidmodel.sidang[0,i]=model[2]
metroconfig.sidmodel.sidang[1,i]=model[3]
metroconfig.sidmodel.axisoffang[i]=model[4]
metroconfig.sidmodel.zeroang[0,i]=model[5]
metroconfig.sidmodel.mirroroffang[i]=model[6]
metroconfig.sidmodel.zeroang[1,i]=model[7]
;
return,0
;
end
