function sidpointing,m_in,x_in,dir
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Converts (az,el) into (ha,dec) for dir=+1,
;          (ha,dec) into (az,el) for dir=-1.
;
if n_elements(dir) eq 0 then return,-1
dir=long(dir)
;
x=double(reform(x_in))
;
model=double(m_in)
r=size(model)
if r[0] eq 1 then m=0L else m=r[1]
;
case dir of
	1: begin
	   az=+x[0,*]
	   el=-x[1,*]
	   ha=az
	   dec=el
	   end
       -1: begin
	   ha=x[0,*]
	   dec=x[1,*]
	   az=ha
	   el=dec
	   end
     else: return,0
endcase
n=n_elements(az)
status=linknload(!external_lib,'siderostat',n,ha,dec,az,el,model,m,dir)
case dir of
	1: return,natural(ha,dec)
       -1: return,natural(az,-el)
endcase
;
end
