function siggen,pwr,fmax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return signal whose power spectrum is equal to pwr.
; pwr is given for frequencies from zero to fmax [Hz] in equal increments.
;
common LocalSiggen,seed
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
n=n_elements(pwr)-1
sampling_int=1/(2*fmax)
norm_factor=n/((1/sampling_int)/2)
;
p=sqrt(pwr/(2*norm_factor))*exp(2*pi_circle*i_complex*randomu(seed,n+1))
p=[p,conj(reverse(p[1:n-1]))]
s=float(fft(p,1))
return,s
;
end
