function signalfilter,signal,filter
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Apply a filter to signal.
; The frequencies are returned by fft in this order:
; DC,min,max,-min	(even number of elements n in signal)
; DC,min,max,-max,-min	(odd number of elements n in signal)
;
; Filter should have n/2+1 elements for both even and odd cases.
;
; Compute power spectrum
p=fft(signal,-1)
n=n_elements(signal)
if n mod 2 eq 0 then begin
	p[0:n/2]=p[0:n/2]*filter[0:n/2]
	p[n/2+1:n-1]=p[n/2+1:n-1]*reverse(filter[1:n/2-1])
endif else begin
	p[0:n/2]=p[0:n/2]*filter[0:n/2]
	p[n/2+1:n-1]=p[n/2+1:n-1]*reverse(filter[1:n/2])
;	p(0:n-1)=p(0:n-1)*filter
;	p(n:n*2-1)=p(n:n*2-1)*reverse(filter)
endelse
return,float(fft(p,1))
;
end
