function sockel,map_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Away from the source, the mean map level should drop to zero. Otherwise,
; the Fourier transform would be normalized incorrectly, and this function
; determined the mean baseline from looking at the means in annuli around
; the map center.
;
map=map_in
;
n=n_elements(map)
;
imsize=n_elements(map[*,0])
jmsize=n_elements(map[0,*])
;
a=float(imsize)/2
b=float(jmsize)/2
;
; Where is the source?
k=where(map eq max(map))
imax=k mod imsize
jmax=k  /  jmsize
;
; We use the map center for now
imax=imsize/2
jmax=jmsize/2
;
x=(findgen(n) mod imsize) - imax
y=(findgen(n)  /  imsize) - jmax
;
; Have the radius trace out an ellipse
r=sqrt((x/a)^2+(y/b)^2)
;
maxr=max(r)
nring=20
rstep=maxr/nring
level=fltarr(nring)
ratio=fltarr(nring)+1
;
; Find the radius outside of which the mean level stays constant
for i=0,nring-1 do begin
;
	index=where(r gt i*rstep and r lt (i+1)*rstep)
	level[i]=mean(map[index])/max(map)	; % levels
	if i gt 0 then ratio[i]=abs(level[i-1]-level[i])
;
endfor
;
i=where(ratio lt 0.01 and level lt 0.1,count)
;
if count gt 0 then return,mean(map[where(r gt i[0]*rstep)]) $
	      else return,0
;
if count gt 0 then begin
	map[where(r le i[0]*rstep)]=mean(map[where(r gt i[0]*rstep and r lt (i[0]+1)*rs
	return,mean(map)
endif else return,0
;
end
