pro solve,vis,lambda,soln,pt=pt,plot=plot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; lambda [m]
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
forward_function fringeid
;
if n_elements(pt) eq 0 then pt=0
if n_elements(plot) eq 0 then plot=0
;
phase=phaseunwrap(cphase(vis))/(2*!pi)
;
sigma=1.d0/(lambda*1.d6)
nrow=n_elements(sigma)+1
nump=n_elements(phase[0,*])
p=dblarr(nrow,nump)
p[0:nrow-2,*]=phase
;
a=a_disp[0]+a_disp[1]/(a_disp[2]-sigma^2)+a_disp[3]/(a_disp[4]-sigma^2)
a=a/10000.d0  ; We want coefficients of similar magnitude
b=b_disp[0]+b_disp[1]*sigma^2
;
; Standard solution
m=dblarr(n_elements(sigma),3)
m[*,0]=sigma
m[*,1]=sigma*a
m[*,2]=1
tm=transpose(m)
norm=tm#m
r=tm#phase
s=invert(norm)#r
soln=s
fidsol=s[2,*]
;
; Plot the fits
if plot then begin
	n=20
	x=findgen(n)/10
	m=dblarr(n_elements(x),3)
	m[*,0]=x
	m[*,1]=x $
	      *(a_disp[0]+a_disp[1]/(a_disp[2]-x^2) $
		+a_disp[3]/(a_disp[4]-x^2)) $
	      /10000.d0
	m[*,2]=1
	y=reform(m#s)
	r=size(y)
	if r[0] eq 2 then plot_slide,sigma,phase,y2=y,x2=x $
		     else begin
			  wset,0
			  plot,sigma,phase,psym=1,xrange=[0,2],yrange=[-1,1]
			  oplot,x,y,psym=0
			  endelse
endif
;
; Forced integer ID solution
s[2,*]=fringeid(s[2,*])
new_offset=min(s[2,*] mod 1)
if pt then s[2,*]=medianve(s[2,*])
m=dblarr(nrow,3)
m[0:nrow-2,0]=sigma
m[0:nrow-2,1]=sigma*a
m[0:nrow-2,2]=1
m[  nrow-1,2]=1
tm=transpose(m)
norm=tm#m
p[nrow-1,*]=s[2,*]
r=tm#p
s=invert(norm)#r
soln=s
soln[2,*]=fidsol
return
;
; Forced integer ID solutions
num_id=9
s=dblarr(num_id,3,nump)
rmsq=fltarr(num_id,nump)
for i=-num_id/2,num_id/2 do begin
	tm=transpose(m)
	norm=tm#m
	p[nrow-1,*]=i+new_offset
	r=tm#p
	s[i+num_id/2,*,*]=invert(norm)#r
	rmsq[i+num_id/2,*]=total((m#reform(s[i+num_id/2,*,*])-p)^2,1)
endfor
for i=0,nump-1 do begin
	x=min(rmsq[*,i],j)
	soln[*,i]=s[j,*,i]
endfor
;
; Contents of solution vector:
; vacuum delay, air path, fringe ID
; add vac to FDL delay
;
end
