pro spec_parse,spectra,type,class,type2,class2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Call the C function specparse which parses spectra strings into integer
; types and classes. If called without arguments, initialize types and
; classes in the startable according to the spectral classifications.
;
common StarBase,StarTable,Notes
;
; Save a copy of the input spectra, if any
if n_elements(spectra) gt 0 then spectra_in=spectra
;
if n_elements(spectra) eq 0 then spectra=StarTable.spectrum $
			    else spectra=strupcase(spectra)
index=where(strlen(spectra) eq 0,count)
if count gt 0 then spectra[index]=' '
index=where(strpos(startable.spectrum,'[WC') ge 0,count)
for i=0,count-1 do begin
	spectrum=startable[index[i]].spectrum
	startable[index[i]].spectrum= $
		strsplit(strsplit(spectrum,'[',/extract),']',/extract)
endfor
;
n=n_elements(spectra)
type=fltarr(n)		; 0=O-type, 1=B-type, 2=A-type, 34=F4
type2=fltarr(n)		; Same for companion
class=fltarr(n)		; 5=V=dwarf,...
class2=fltarr(n)	; Same for companion
;
status=linknload(!external_lib,'specparse',n,spectra,type,type2,class,class2)
; for j=0,n_elements(spectra)-1 do begin
;	print,spectra(j),type(j),type2(j),class(j),class2(j)
; endfor
;
; Process WR stars separately
index_wr=where(strmid(spectra,0,2) eq 'WC',n_wr) ; The WR is always the 1st star
for i=0,n_wr-1 do begin
	j=index_wr[i]		; Index into spectra for this WR
	type[j]=-type[j]	; negative type for WRs
;	Example spectra: WC WC+... WC... WC4 WC4+O WC4+O5-6 WC4+O9 WC8+O7.5e
	spectrum=nameparse(spectra[j],['+','...'])	; e.g.: 'WC...'
	if n_elements(spectrum) eq 2 then begin
		if strlen(spectrum[1]) eq 0 then spectrum=spectrum[0]
	endif
	if n_elements(spectrum) eq 2 then begin
		class[j]=float(strmid(spectra[j],2,1))
		class2[j]=float(strmid(spectra[j],2,1))
	endif else begin
		class[j]=float(strmid(spectra[j],2,1))
	endelse
endfor
;
if n_params() eq 0 then begin
	StarTable.spectrum=spectra
	StarTable.type=type
	StarTable.type2=type2
	StarTable.class=class
	StarTable.class2=class2
endif
;
; Restore the input spectra
if n_elements(spectra_in) ne 0 then spectra=spectra_in
;
end
